/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.util.PathUtil;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.util.Visitor;

public class PackageNameMappingRegistry {
    private static final Logger LOG = Logger.getLogger(PackageNameMappingRegistry.class.getSimpleName());
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private RuleProviderRegistryCache cache;
    private GraphRewrite event;

    public String getOrganizationForPackage(String packageName) {
        return PackageNameMapping.getOrganizationForPackage(this.event, packageName);
    }

    public void loadPackageMappings() {
        try (GraphContext graphContext = this.graphContextFactory.create();){
            WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
            FileModel windupRulesPath = new FileService(graphContext).createByFilePath(PathUtil.getWindupRulesDir().toString());
            configurationModel.addUserRulesPath(windupRulesPath);
            RuleProviderRegistry registry = this.cache.getRuleProviderRegistry(graphContext);
            this.event = new GraphRewrite(graphContext);
            RuleSubset ruleSubset = RuleSubset.create((Configuration)registry.getConfiguration());
            new RuleVisit((Rule)ruleSubset).accept((Visitor)new Visitor<Rule>(){

                public void visit(Rule r) {
                    if (r instanceof PackageNameMapping) {
                        ((PackageNameMapping)r).preRulesetEvaluation(PackageNameMappingRegistry.this.event);
                    }
                }
            });
            graphContext.clear();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load rule information due to: " + e.getMessage(), e);
        }
    }
}

