/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.ArchiveMetadataExtractionPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.LicenseModel;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverArchiveLicenseFilesRuleProvider
extends IteratingRuleProvider<ArchiveModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverArchiveLicenseFilesRuleProvider.class.getSimpleName());
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public DiscoverArchiveLicenseFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverArchiveLicenseFilesRuleProvider.class).setPhase(ArchiveMetadataExtractionPhase.class));
    }

    public String toStringPerform() {
        return "DiscoverArchiveLicenseFiles";
    }

    public ConditionBuilder when() {
        return Query.fromType(ArchiveModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        Rule rule = (Rule)context.get(Rule.class);
        Set<FileModel> licenseFiles = this.findLicense(payload);
        if (licenseFiles.isEmpty()) {
            return;
        }
        LinkService linkService = new LinkService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        GraphService licenseService = new GraphService(event.getGraphContext(), LicenseModel.class);
        for (FileModel license : licenseFiles) {
            LOG.info("Classifying: " + license.getFileName() + " as License within archive: " + payload.getArchiveName());
            try {
                InputStream stream = license.asInputStream();
                Throwable throwable = null;
                try {
                    ClassificationModel classificationModel;
                    String content = IOUtils.toString((InputStream)stream);
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Apache License, Version 2.0")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 2.0", "Apache License 2.0 File", "http://www.apache.org/licenses/LICENSE-2.0");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Apache_License", "Apache License Wikipedia");
                        this.addLink(classificationService, linkService, classificationModel, "http://www.apache.org/licenses/", "Apache License Website");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Apache Software License, Version 1.1")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 1.1", "Apache License 1.1 File", "http://www.apache.org/licenses/LICENSE-1.1");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Apache_License", "Apache License Wikipedia");
                        this.addLink(classificationService, linkService, classificationModel, "http://www.apache.org/licenses/", "Apache License Website");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Copyright (c) 1995-1999 The Apache Group.  All rights reserved.")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 1.0", "Apache License 1.0 File", "http://www.apache.org/licenses/LICENSE-1.0");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Apache_License", "Apache License Wikipedia");
                        this.addLink(classificationService, linkService, classificationModel, "http://www.apache.org/licenses/", "Apache License Website");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"GNU General Public License")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "GNU GPL", "GNU General Public License File", "http://opensource.org/licenses/gpl-license");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/GNU_General_Public_License", "GNU License Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"The MIT License (MIT)")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "MIT License", "GNU General Public License File", "http://opensource.org/licenses/MIT");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/MIT_License", "MIT License Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Mozilla Public License, version 2.0")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Mozilla Public License 2.0", "Mozilla Public License 2.0 File", "http://opensource.org/licenses/MPL-2.0");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Mozilla_Public_License", "Mozilla License Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"GNU Lesser General Public License")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "GNU LGPL", "GNU LGPL File", "http://opensource.org/licenses/lgpl-license");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/GNU_Lesser_General_Public_License", "GNU LGPL License Wikipedia");
                        continue;
                    }
                    if (StringUtils.contains((String)content, (String)"COMMON DEVELOPMENT AND DISTRIBUTION LICENSE")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "CDDL", "CDDL License File", "http://opensource.org/licenses/CDDL-1.0");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Common_Development_and_Distribution_License", "CDDL Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Eclipse Public License")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Eclipse Public License 1.0", "Eclipse Public License 1.0 File", "http://opensource.org/licenses/EPL-1.0");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/Eclipse_Public_License", "Eclipse Public License Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"Redistribution and use in source and binary forms")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "BSD License", "BSD License File", "http://opensource.org/licenses/");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/BSD_licenses", "BSD Licenses Wikipedia");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((String)content, (String)"the work of authorship identified is in the public domain of the country")) {
                        classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Public Domain License", "Creative Commons Public Domain License File", "http://creativecommons.org/licenses/publicdomain/");
                        this.addLink(classificationService, linkService, classificationModel, "http://en.wikipedia.org/wiki/BSD_licenses", "BSD Licenses Wikipedia");
                        continue;
                    }
                    LOG.warning("Must be unknown license type: " + license.getFileName());
                    classificationModel = this.tagLicense(rule, classificationService, linkService, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Unknown License", "Unknown License File", "Unknown License File");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private ClassificationModel tagLicense(Rule rule, ClassificationService classificationService, LinkService linkService, GraphService<LicenseModel> licenseService, TechnologyTagService technologyTagService, FileModel license, String name, String description, String url) {
        ClassificationModel classification = classificationService.attachClassification(rule, license, name, description);
        LOG.info("Identified: " + license.getFileName() + " as: " + name);
        LicenseModel model = (LicenseModel)licenseService.addTypeToModel((WindupVertexFrame)license);
        model.setName(name);
        model.setURL(url);
        technologyTagService.addTagToFileModel(license, name, TECH_TAG_LEVEL);
        return classification;
    }

    private void addLink(ClassificationService classificationService, LinkService linkService, ClassificationModel classificationModel, String url, String description) {
        LinkModel link = linkService.getOrCreate(description, url);
        classificationService.attachLink(classificationModel, link);
    }

    private Set<FileModel> findLicense(ArchiveModel archive) {
        HashSet<FileModel> licenses = new HashSet<FileModel>();
        Iterable files = archive.getContainedFileModels();
        for (FileModel model : files) {
            if (model.isDirectory()) continue;
            String fileName = model.getFileName();
            if (!(fileName = StringUtils.lowerCase((String)fileName)).endsWith("license.txt") && !fileName.endsWith("license") && !fileName.endsWith("gpl.txt") && !fileName.endsWith("lgpl.txt") && !fileName.endsWith("notice.txt") && !fileName.endsWith("notice")) continue;
            licenses.add(model);
        }
        return licenses;
    }
}

