/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Collections;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.ui.impl.input.AbstractInputComponent;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.furnace.util.Callables;

@Vetoed
public abstract class AbstractUISelectInputComponent<IMPLTYPE extends SelectComponent<IMPLTYPE, VALUETYPE>, VALUETYPE>
extends AbstractInputComponent<IMPLTYPE, VALUETYPE>
implements SelectComponent<IMPLTYPE, VALUETYPE> {
    private Callable<Iterable<VALUETYPE>> choices;
    private Converter<VALUETYPE, String> itemLabelConverter;

    public AbstractUISelectInputComponent(String name, char shortName, Class<VALUETYPE> type) {
        super(name, shortName, type);
    }

    public Converter<VALUETYPE, String> getItemLabelConverter() {
        return this.itemLabelConverter;
    }

    public IMPLTYPE setItemLabelConverter(Converter<VALUETYPE, String> converter) {
        this.itemLabelConverter = converter;
        return (IMPLTYPE)((Object)this);
    }

    public Iterable<VALUETYPE> getValueChoices() {
        Iterable valueChoices = (Iterable)Callables.call(this.choices);
        return valueChoices == null ? Collections.emptyList() : valueChoices;
    }

    public IMPLTYPE setValueChoices(Iterable<VALUETYPE> choices) {
        this.choices = Callables.returning(choices);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setValueChoices(Callable<Iterable<VALUETYPE>> choices) {
        this.choices = choices;
        return (IMPLTYPE)((Object)this);
    }

    protected void assertChoicesInValueChoices(Iterable<VALUETYPE> choices) {
        if (choices != null) {
            for (VALUETYPE choice : choices) {
                this.assertChoiceInValueChoices(choice);
            }
        }
    }

    protected void assertChoiceInValueChoices(VALUETYPE choice) {
        if (choice != null) {
            for (VALUETYPE type : this.getValueChoices()) {
                if (!type.equals(choice)) continue;
                return;
            }
            throw new IllegalArgumentException(choice + " is not a valid value for " + this.getName());
        }
    }
}

