/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.JPAConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.service.JPAConfigurationFileService;
import org.jboss.windup.rules.apps.javaee.service.JPAEntityService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateJPAReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_JPA_REPORT = "/reports/templates/jpa.ftl";

    public CreateJPAReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateJPAReportRuleProvider.class, (String)"Create JPA Report").setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        GraphOperation addReport = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : windupConfiguration.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    if (projectModel == null) {
                        throw new WindupException("Error, no project found in: " + inputPath.getFilePath());
                    }
                    CreateJPAReportRuleProvider.this.createJPAReport(event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "CreateJPAReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)addReport);
    }

    private void createJPAReport(GraphContext context, ProjectModel projectModel) {
        JPAConfigurationFileService jpaConfigurationFileService = new JPAConfigurationFileService(context);
        JPAEntityService jpaEntityService = new JPAEntityService(context);
        GraphService jpaNamedQueryService = new GraphService(context, JPANamedQueryModel.class);
        ArrayList<JPAConfigurationFileModel> jpaConfigList = new ArrayList<JPAConfigurationFileModel>();
        for (JPAConfigurationFileModel jpaConfig : jpaConfigurationFileService.findAll()) {
            if (!jpaConfig.getApplication().equals(projectModel)) continue;
            jpaConfigList.add(jpaConfig);
        }
        ArrayList<JPAEntityModel> entityList = new ArrayList<JPAEntityModel>();
        for (JPAEntityModel entityModel : jpaEntityService.findAll()) {
            if (!entityModel.getApplication().equals(projectModel)) continue;
            entityList.add(entityModel);
        }
        ArrayList<JPANamedQueryModel> namedQueryList = new ArrayList<JPANamedQueryModel>();
        for (JPANamedQueryModel namedQuery : jpaNamedQueryService.findAll()) {
            if (!namedQuery.getJpaEntity().getApplication().equals(projectModel)) continue;
            namedQueryList.add(namedQuery);
        }
        if (jpaConfigList.isEmpty() && entityList.isEmpty() && namedQueryList.isEmpty()) {
            return;
        }
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(3);
        additionalData.put("jpaConfiguration", ((WindupVertexListModel)listService.create()).addAll(jpaConfigList));
        additionalData.put("jpaEntities", ((WindupVertexListModel)listService.create()).addAll(entityList));
        additionalData.put("jpaNamedQueries", ((WindupVertexListModel)listService.create()).addAll(namedQueryList));
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(400);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("JPA");
        applicationReportModel.setReportIconClass("glyphicon jpa-nav-logo");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_JPA_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "jpa_" + projectModel.getName(), "html");
    }
}

