/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.orion;

import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverWebXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveOrionWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveOrionWebXmlRuleProvider.class.getSimpleName());

    public ResolveOrionWebXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveOrionWebXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverWebXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover Orion Web XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"orion-web-app");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(context, payload);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "web.xml");
        TechnologyTagModel technologyTag = technologyTagService.addTagToFileModel((FileModel)payload, "Orion Web XML", TechnologyTagLevel.IMPORTANT);
        for (Element orionWeb : JOOX.$((Document)doc).child("orion-web-app")) {
            String majorVersion = JOOX.$((Element)orionWeb).attr("schema-major-version");
            String minorVersion = JOOX.$((Element)orionWeb).attr("schema-minor-version");
            if (!StringUtils.isNotBlank((String)majorVersion)) continue;
            String version = majorVersion;
            if (StringUtils.isNotBlank((String)minorVersion)) {
                version = version + "." + minorVersion;
            }
            technologyTag.setVersion(version);
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref-mapping").get()) {
            String jndiLocation = JOOX.$((Element)resourceRef).attr("location");
            String resourceName = JOOX.$((Element)resourceRef).attr("name");
            JNDIResourceModel resource = jndiResourceService.createUnique(payload.getApplication(), jndiLocation);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

