/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.weblogic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.model.ThreadPoolModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveWeblogicEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWeblogicEjbXmlRuleProvider.class.getSimpleName());

    public ResolveWeblogicEjbXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveWeblogicEjbXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverEjbConfigurationXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover Weblogic EJB XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"weblogic-ejb-jar");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        String jndiLocation;
        JNDIResourceModel resource;
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        GraphService threadPoolService = new GraphService(event.getGraphContext(), ThreadPoolModel.class);
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification(context, (FileModel)payload, "Weblogic EJB XML", "Weblogic Enterprise Java Bean XML Descriptor.");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "Weblogic EJB XML", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(context, payload);
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-description").get()) {
            String jndiLocation2 = JOOX.$((Element)resourceRef).child("jndi-name").text();
            String resourceName = JOOX.$((Element)resourceRef).child("res-ref-name").text();
            if (!StringUtils.isNotBlank((String)jndiLocation2) || !StringUtils.isNotBlank((String)resourceName)) continue;
            resource = jndiResourceService.createUnique(payload.getApplication(), jndiLocation2);
            LOG.info("JNDI Name: " + jndiLocation2 + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-reference-description").get()) {
            String resourceName = JOOX.$((Element)resourceRef).child("ejb-ref-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            if (!StringUtils.isNotBlank((String)jndiLocation) || !StringUtils.isNotBlank((String)resourceName)) continue;
            resource = jndiResourceService.createUnique(payload.getApplication(), jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)resourceName)) {
                ejb.setGlobalJndiReference(resource);
            }
        }
        for (Element enterpriseBeanTag : JOOX.$((Document)doc).find("weblogic-enterprise-bean").get()) {
            String localJndiLocation = JOOX.$((Element)enterpriseBeanTag).child("local-jndi-name").text();
            jndiLocation = JOOX.$((Element)enterpriseBeanTag).child("jndi-name").text();
            String ejbName = JOOX.$((Element)enterpriseBeanTag).child("ejb-name").text();
            String sessionClustered = JOOX.$((Element)enterpriseBeanTag).find("stateless-bean-is-clusterable").text();
            if (StringUtils.isBlank((String)(sessionClustered = StringUtils.trim((String)sessionClustered)))) {
                sessionClustered = JOOX.$((Element)enterpriseBeanTag).find("home-is-clusterable").text();
                sessionClustered = StringUtils.trim((String)sessionClustered);
            }
            ThreadPoolModel threadPoolModel = null;
            Iterator<Object> i$ = JOOX.$((Element)enterpriseBeanTag).find("pool").get().iterator();
            if (i$.hasNext()) {
                Element poolDescriptor = (Element)i$.next();
                String maxSize = JOOX.$((Element)poolDescriptor).child("max-beans-in-free-pool").text();
                String minSize = JOOX.$((Element)poolDescriptor).child("initial-beans-in-free-pool").text();
                threadPoolModel = (ThreadPoolModel)threadPoolService.create();
                threadPoolModel.setApplication(payload.getApplication());
                threadPoolModel.setPoolName(ejbName + "-ThreadPool");
                if (StringUtils.isNotBlank((String)maxSize)) {
                    try {
                        threadPoolModel.setMaxPoolSize(Integer.parseInt(maxSize));
                    }
                    catch (Exception e) {
                        LOG.warning("Unable to parse max pool size: " + maxSize);
                    }
                }
                if (StringUtils.isNotBlank((String)minSize)) {
                    try {
                        threadPoolModel.setMinPoolSize(Integer.parseInt(minSize));
                    }
                    catch (Exception e) {
                        LOG.warning("Unable to parse min pool size: " + minSize);
                    }
                }
            }
            if (threadPoolModel != null) {
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    sessionBean.setThreadPool(threadPoolModel);
                }
                for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    mdb.setThreadPool(threadPoolModel);
                }
            }
            Map<String, Integer> txTimeouts = this.parseTxTimeout(enterpriseBeanTag, ejbName);
            if (StringUtils.isNotBlank((String)jndiLocation) && StringUtils.isNotBlank((String)ejbName)) {
                JNDIResourceModel jndiRef = jndiResourceService.createUnique(payload.getApplication(), jndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setGlobalJndiReference(jndiRef);
                }
            }
            if (StringUtils.isNotBlank((String)localJndiLocation) && StringUtils.isNotBlank((String)ejbName)) {
                JNDIResourceModel localJndiRef = jndiResourceService.createUnique(payload.getApplication(), localJndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setLocalJndiReference(localJndiRef);
                }
            }
            if (txTimeouts.size() > 0 && StringUtils.isNotBlank((String)ejbName)) {
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    sessionBean.setTxTimeouts(txTimeouts);
                }
            }
            for (Element messageDrivenDescriptor : JOOX.$((Element)enterpriseBeanTag).find("message-driven-descriptor").get()) {
                for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    String destination = JOOX.$((Element)messageDrivenDescriptor).child("destination-jndi-name").text();
                    if (StringUtils.isNotBlank((String)destination)) {
                        JmsDestinationModel jndiRef = jmsDestinationService.createUnique(payload.getApplication(), destination);
                        mdb.setDestination(jndiRef);
                    }
                    if (txTimeouts.size() <= 0) continue;
                    mdb.setTxTimeouts(txTimeouts);
                }
            }
            if (!StringUtils.equalsIgnoreCase((String)"true", (String)sessionClustered)) continue;
            for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                LOG.info("Setting bean as clustered: " + ejbName);
                sessionBean.setClustered(true);
            }
        }
    }

    private Map<String, Integer> parseTxTimeout(Element enterpriseBeanTag, String ejbName) {
        HashMap<String, Integer> transactionTimeouts = new HashMap<String, Integer>();
        String transactionTimeoutSeconds = JOOX.$((Element)enterpriseBeanTag).child("transaction-descriptor").child("trans-timeout-seconds").text();
        String methodName = "*";
        if (StringUtils.isNotBlank((String)transactionTimeoutSeconds)) {
            try {
                Integer txTimeout = Integer.parseInt(transactionTimeoutSeconds);
                transactionTimeouts.put(methodName, txTimeout);
            }
            catch (Exception e) {
                LOG.info("EJB: " + ejbName + " contains bad reference to TX Timeout on Method: " + methodName);
            }
        }
        return transactionTimeouts;
    }
}

