/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverWebXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveWebsphereWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWebsphereWebXmlRuleProvider.class.getSimpleName());

    public ResolveWebsphereWebXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveWebsphereWebXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverWebXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover IBM Websphere Web Binding Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-web-bnd.xmi");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        ClassificationModel classification = classificationService.attachClassification(context, (FileModel)payload, "Websphere Web Binding", "Websphere Web Binding XML Descriptor");
        classification.setEffort(1);
        Document doc = xmlFileService.loadDocumentQuiet(context, payload);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "web.xml");
        TechnologyTagModel technologyTag = technologyTagService.addTagToFileModel((FileModel)payload, "Websphere Web XML", TechnologyTagLevel.IMPORTANT);
        for (Element resourceRef : JOOX.$((Document)doc).find("resRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, payload.getApplication(), resourceRef, "bindingResourceRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejbRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, payload.getApplication(), resourceRef, "bindingEjbRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("messageDestinationRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, payload.getApplication(), resourceRef, "bindingMessageDestinationRef");
        }
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, ProjectModel application, Element resourceRef, String tagName) {
        String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
        String resourceId = JOOX.$((Element)resourceRef).child(tagName).attr("href");
        if (StringUtils.isBlank((String)(resourceId = StringUtils.substringAfter((String)resourceId, (String)"WEB-INF/web.xml#")))) {
            LOG.info("Issue Element: " + JOOX.$((Element)resourceRef).toString());
            return;
        }
        if (StringUtils.isNotBlank((String)jndiLocation)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(application, jndiLocation);
            LOG.info("JNDI: " + jndiLocation + " Resource: " + resourceId);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("referenceId", resourceId)) {
                LOG.info(" - Associating JNDI: " + jndiLocation + " Resource: " + ref);
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

