/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Rule;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontSkipActionsInPredicates;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.common.ArrayBuilder;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.StringBuilderVar;
import org.parboiled.support.StringVar;
import org.parboiled.support.Var;
import org.pegdown.Extensions;
import org.pegdown.ParsingTimeoutException;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.ValidEmphOrStrongCloseNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.WikiLinkNode;
import org.pegdown.plugins.PegDownPlugins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends BaseParser<Object>
implements Extensions {
    protected static final char CROSSED_OUT = '\uffff';
    public static ParseRunnerProvider DefaultParseRunnerProvider = new ParseRunnerProvider(){

        @Override
        public ParseRunner<Node> get(Rule rule) {
            return new ReportingParseRunner(rule);
        }
    };
    protected final int options;
    protected final long maxParsingTimeInMillis;
    protected final ParseRunnerProvider parseRunnerProvider;
    protected final PegDownPlugins plugins;
    final List<AbbreviationNode> abbreviations = new ArrayList<AbbreviationNode>();
    final List<ReferenceNode> references = new ArrayList<ReferenceNode>();
    long parsingStartTimeStamp = 0L;
    protected static final String[] HTML_TAGS = new String[]{"address", "blockquote", "center", "dd", "dir", "div", "dl", "dt", "fieldset", "form", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "isindex", "li", "menu", "noframes", "noscript", "ol", "p", "pre", "script", "style", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "ul"};

    public Parser(Integer options, Long maxParsingTimeInMillis, ParseRunnerProvider parseRunnerProvider, PegDownPlugins plugins) {
        this.options = options;
        this.maxParsingTimeInMillis = maxParsingTimeInMillis;
        this.parseRunnerProvider = parseRunnerProvider;
        this.plugins = plugins;
    }

    public Parser(Integer options, Long maxParsingTimeInMillis, ParseRunnerProvider parseRunnerProvider) {
        this(options, maxParsingTimeInMillis, parseRunnerProvider, PegDownPlugins.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootNode parse(char[] source) {
        try {
            RootNode root = this.parseInternal(source);
            root.setAbbreviations((List<AbbreviationNode>)ImmutableList.copyOf(this.abbreviations));
            root.setReferences((List<ReferenceNode>)ImmutableList.copyOf(this.references));
            RootNode rootNode = root;
            return rootNode;
        }
        finally {
            this.abbreviations.clear();
            this.references.clear();
        }
    }

    public Rule Root() {
        return this.NodeSequence(this.push(new RootNode()), this.ZeroOrMore(this.Block(), this.addAsChild(), new Object[0]));
    }

    public Rule Block() {
        return this.Sequence(this.ZeroOrMore(this.BlankLine()), this.FirstOf(new ArrayBuilder().add((Object[])this.plugins.getBlockPluginRules()).add((Object[])new Rule[]{this.BlockQuote(), this.Verbatim()}).addNonNulls((Object[])new Rule[]{this.ext(4) ? this.Abbreviation() : null}).add((Object[])new Rule[]{this.Reference(), this.HorizontalRule(), this.Heading(), this.OrderedList(), this.BulletList(), this.HtmlBlock()}).addNonNulls((Object[])new Rule[]{this.ext(32) ? this.Table() : null}).addNonNulls((Object[])new Rule[]{this.ext(64) ? this.DefinitionList() : null}).addNonNulls((Object[])new Rule[]{this.ext(128) ? this.FencedCodeBlock() : null}).add((Object[])new Rule[]{this.Para(), this.Inlines()}).get()), new Object[0]);
    }

    public Rule Para() {
        return this.NodeSequence(this.NonindentSpace(), this.Inlines(), this.push(new ParaNode(this.popAsNode())), this.OneOrMore(this.BlankLine()));
    }

    public Rule BlockQuote() {
        StringBuilderVar inner = new StringBuilderVar();
        return this.NodeSequence(this.OneOrMore(this.CrossedOut(this.Sequence(Character.valueOf('>'), this.Optional(Character.valueOf(' ')), new Object[0]), inner), this.Line(inner), new Object[]{this.ZeroOrMore(this.TestNot(Character.valueOf('>')), this.TestNot(this.BlankLine()), new Object[]{this.Line(inner)}), this.ZeroOrMore(this.BlankLine(), inner.append(this.match()), new Object[0])}), this.push(new BlockQuoteNode(this.withIndicesShifted(this.parseInternal(inner), (Integer)this.peek()).getChildren())));
    }

    public Rule Verbatim() {
        StringBuilderVar text = new StringBuilderVar();
        StringBuilderVar line = new StringBuilderVar();
        return this.NodeSequence(this.OneOrMore(this.ZeroOrMore(this.BlankLine(), line.append("\n"), new Object[0]), this.Indent(), new Object[]{this.push(this.currentIndex()), this.OneOrMore(this.FirstOf(this.Sequence(Character.valueOf('\t'), line.append(StringUtils.repeat((char)' ', (int)(4 - (this.currentIndex() - 1 - (Integer)this.peek()) % 4))), new Object[0]), this.Sequence(this.NotNewline(), ANY, new Object[]{line.append(this.matchedChar())}), new Object[0])), this.Newline(), text.appended(line.getString()).append('\n') && line.clearContents() && this.drop()}), this.push(new VerbatimNode(text.getString())));
    }

    public Rule FencedCodeBlock() {
        StringBuilderVar text = new StringBuilderVar();
        Var markerLength = new Var();
        return this.NodeSequence(this.CodeFence((Var<Integer>)markerLength), this.TestNot(this.CodeFence((Var<Integer>)markerLength)), this.ZeroOrMore(this.BlankLine(), text.append('\n'), new Object[0]), this.OneOrMore(this.TestNot(this.Newline(), this.CodeFence((Var<Integer>)markerLength), new Object[0]), ANY, new Object[]{text.append(this.matchedChar())}), this.Newline(), this.push(new VerbatimNode(text.appended('\n').getString(), this.popAsString())), this.CodeFence((Var<Integer>)markerLength), this.drop());
    }

    @Cached
    public Rule CodeFence(Var<Integer> markerLength) {
        return this.Sequence(this.FirstOf(this.NOrMore('~', 3), this.NOrMore('`', 3), new Object[0]), markerLength.isSet() && this.matchLength() == ((Integer)markerLength.get()).intValue() || markerLength.isNotSet() && markerLength.set((Object)this.matchLength()), new Object[]{this.Sp(), this.ZeroOrMore(this.TestNot(this.Newline()), ANY, new Object[0]), this.push(this.match()), this.Newline()});
    }

    public Rule HorizontalRule() {
        return this.NodeSequence(this.NonindentSpace(), this.FirstOf(this.HorizontalRule('*'), this.HorizontalRule('-'), new Object[]{this.HorizontalRule('_')}), this.Sp(), this.Newline(), this.OneOrMore(this.BlankLine()), this.push(new SimpleNode(SimpleNode.Type.HRule)));
    }

    public Rule HorizontalRule(char c) {
        return this.Sequence(Character.valueOf(c), this.Sp(), new Object[]{Character.valueOf(c), this.Sp(), Character.valueOf(c), this.ZeroOrMore(this.Sp(), Character.valueOf(c), new Object[0])});
    }

    public Rule Heading() {
        return this.NodeSequence(this.FirstOf(this.AtxHeading(), this.SetextHeading(), new Object[0]));
    }

    public Rule AtxHeading() {
        return this.Sequence(this.AtxStart(), this.Optional(this.Sp()), new Object[]{this.OneOrMore(this.AtxInline(), this.addAsChild(), new Object[0]), this.Optional(this.Sp(), this.ZeroOrMore(Character.valueOf('#')), new Object[]{this.Sp()}), this.Newline()});
    }

    public Rule AtxStart() {
        return this.Sequence(this.FirstOf("######", "#####", new Object[]{"####", "###", "##", "#"}), this.push(new HeaderNode(this.match().length())), new Object[0]);
    }

    public Rule AtxInline() {
        return this.Sequence(this.TestNot(this.Newline()), this.TestNot(this.Optional(this.Sp()), this.ZeroOrMore(Character.valueOf('#')), new Object[]{this.Sp(), this.Newline()}), new Object[]{this.Inline()});
    }

    public Rule SetextHeading() {
        return this.Sequence(this.Test(this.OneOrMore(this.NotNewline(), ANY, new Object[0]), this.Newline(), new Object[]{this.FirstOf(this.NOrMore('=', 3), this.NOrMore('-', 3), new Object[0]), this.Newline()}), this.FirstOf(this.SetextHeading1(), this.SetextHeading2(), new Object[0]), new Object[0]);
    }

    public Rule SetextHeading1() {
        return this.Sequence(this.SetextInline(), this.push(new HeaderNode(1, this.popAsNode())), new Object[]{this.ZeroOrMore(this.SetextInline(), this.addAsChild(), new Object[0]), this.Newline(), this.NOrMore('=', 3), this.Newline()});
    }

    public Rule SetextHeading2() {
        return this.Sequence(this.SetextInline(), this.push(new HeaderNode(2, this.popAsNode())), new Object[]{this.ZeroOrMore(this.SetextInline(), this.addAsChild(), new Object[0]), this.Newline(), this.NOrMore('-', 3), this.Newline()});
    }

    public Rule SetextInline() {
        return this.Sequence(this.TestNot(this.Endline()), this.Inline(), new Object[0]);
    }

    public Rule DefinitionList() {
        return this.NodeSequence(this.TestNot(this.Spacechar()), this.Test(this.OneOrMore(this.TestNot(this.BlankLine()), this.TestNot(this.DefListBullet()), new Object[]{this.OneOrMore(this.NotNewline(), ANY, new Object[0]), this.Newline()}), this.Optional(this.BlankLine()), new Object[]{this.DefListBullet()}), this.push(new DefinitionListNode()), this.OneOrMore(this.push(new SuperNode()), this.OneOrMore(this.DefListTerm(), this.addAsChild(), new Object[0]), new Object[]{this.OneOrMore(this.Definition(), this.addAsChild(), new Object[0]), ((SuperNode)this.peek(1)).getChildren().addAll(this.popAsNode().getChildren()), this.Optional(this.BlankLine())}));
    }

    public Rule DefListTerm() {
        return this.NodeSequence(this.TestNot(this.Spacechar()), this.TestNot(this.DefListBullet()), this.push(new DefinitionTermNode()), this.OneOrMore(this.DefTermInline(), this.addAsChild(), new Object[0]), this.Optional(Character.valueOf(':')), this.Newline());
    }

    public Rule DefTermInline() {
        return this.Sequence(this.NotNewline(), this.TestNot(Character.valueOf(':'), this.Newline(), new Object[0]), new Object[]{this.Inline()});
    }

    public Rule Definition() {
        SuperNodeCreator itemNodeCreator = new SuperNodeCreator(){

            public SuperNode create(Node child) {
                return new DefinitionNode(child);
            }
        };
        return this.ListItem(this.DefListBullet(), itemNodeCreator);
    }

    public Rule DefListBullet() {
        return this.Sequence(this.NonindentSpace(), this.AnyOf(":~"), new Object[]{this.OneOrMore(this.Spacechar())});
    }

    public Rule BulletList() {
        SuperNodeCreator itemNodeCreator = new SuperNodeCreator(){

            public SuperNode create(Node child) {
                return new ListItemNode(child);
            }
        };
        return this.NodeSequence(this.ListItem(this.Bullet(), itemNodeCreator), this.push(new BulletListNode(this.popAsNode())), this.ZeroOrMore(this.ListItem(this.Bullet(), itemNodeCreator), this.addAsChild(), new Object[0]), this.ZeroOrMore(this.BlankLine()));
    }

    public Rule OrderedList() {
        SuperNodeCreator itemNodeCreator = new SuperNodeCreator(){

            public SuperNode create(Node child) {
                return new ListItemNode(child);
            }
        };
        return this.NodeSequence(this.ListItem(this.Enumerator(), itemNodeCreator), this.push(new OrderedListNode(this.popAsNode())), this.ZeroOrMore(this.ListItem(this.Enumerator(), itemNodeCreator), this.addAsChild(), new Object[0]), this.ZeroOrMore(this.BlankLine()));
    }

    @Cached
    public Rule ListItem(Rule itemStart, SuperNodeCreator itemNodeCreator) {
        StringBuilderVar block = new StringBuilderVar();
        StringBuilderVar temp = new StringBuilderVar();
        Var tight = new Var((Object)false);
        Var tightFirstItem = new Var();
        return this.Sequence(this.push(this.getContext().getCurrentIndex()), this.FirstOf(this.CrossedOut(this.BlankLine(), block), tight.set((Object)true), new Object[0]), new Object[]{this.CrossedOut(itemStart, block), this.Line(block), this.ZeroOrMore(this.Optional(this.CrossedOut(this.Indent(), temp)), this.NotItem(), new Object[]{this.Line(temp), block.append(temp.getString()) && temp.clearContents()}), (Boolean)tight.get() != false ? this.push(tightFirstItem.setAndGet((Object)itemNodeCreator.create(this.parseListBlock(block)))) : this.fixFirstItem((SuperNode)this.peek(1)) && this.push(itemNodeCreator.create(this.parseListBlock(block.appended("\n\n")))), this.ZeroOrMore(this.push(this.getContext().getCurrentIndex()), this.FirstOf(this.Sequence(this.CrossedOut(this.BlankLine(), block), tight.set((Object)false), new Object[0]), tight.set((Object)true), new Object[0]), new Object[]{this.CrossedOut(this.Indent(), block), this.FirstOf(this.DoubleIndentedBlocks(block), this.IndentedBlock(block), new Object[0]), ((Boolean)tight.get() != false ? this.push(this.parseListBlock(block)) : (tightFirstItem.isNotSet() || this.wrapFirstItemInPara((SuperNode)tightFirstItem.get())) && this.push(this.parseListBlock(block.appended("\n\n")))) && this.addAsChild()}), this.setListItemIndices()});
    }

    public Rule CrossedOut(Rule rule, StringBuilderVar block) {
        return this.Sequence(rule, this.appendCrossed(block), new Object[0]);
    }

    public Rule DoubleIndentedBlocks(StringBuilderVar block) {
        StringBuilderVar line = new StringBuilderVar();
        return this.Sequence(this.Indent(), this.TestNot(this.BlankLine()), new Object[]{block.append("    "), this.Line(block), this.ZeroOrMore(this.ZeroOrMore(this.BlankLine(), line.append(this.match()), new Object[0]), this.CrossedOut(this.Indent(), line), new Object[]{this.Indent(), line.append("    "), this.Line(line), block.append(line.getString()) && line.clearContents()})});
    }

    public Rule IndentedBlock(StringBuilderVar block) {
        return this.Sequence(this.Line(block), this.ZeroOrMore(this.FirstOf(this.Sequence(this.TestNot(this.BlankLine()), this.CrossedOut(this.Indent(), block), new Object[0]), this.NotItem(), new Object[0]), this.Line(block), new Object[0]), new Object[0]);
    }

    public Rule NotItem() {
        return this.TestNot(this.FirstOf(new ArrayBuilder().add((Object[])new Rule[]{this.Bullet(), this.Enumerator(), this.BlankLine(), this.HorizontalRule()}).addNonNulls((Object[])new Rule[]{this.ext(64) ? this.DefListBullet() : null}).get()));
    }

    public Rule Enumerator() {
        return this.Sequence(this.NonindentSpace(), this.OneOrMore(this.Digit()), new Object[]{Character.valueOf('.'), this.OneOrMore(this.Spacechar())});
    }

    public Rule Bullet() {
        return this.Sequence(this.TestNot(this.HorizontalRule()), this.NonindentSpace(), new Object[]{this.AnyOf("+*-"), this.OneOrMore(this.Spacechar())});
    }

    boolean appendCrossed(StringBuilderVar block) {
        for (int i = 0; i < this.matchLength(); ++i) {
            block.append('\uffff');
        }
        return true;
    }

    Node parseListBlock(StringBuilderVar block) {
        Context context = this.getContext();
        RootNode innerRoot = this.parseInternal(block);
        this.setContext(context);
        block.clearContents();
        return this.withIndicesShifted(innerRoot, (Integer)context.getValueStack().pop());
    }

    Node withIndicesShifted(Node node, int delta) {
        ((AbstractNode)node).shiftIndices(delta);
        for (Node subNode : node.getChildren()) {
            this.withIndicesShifted(subNode, delta);
        }
        return node;
    }

    boolean fixFirstItem(SuperNode listNode) {
        List<Node> items = listNode.getChildren();
        if (items.size() == 1 && items.get(0) instanceof ListItemNode) {
            this.wrapFirstItemInPara((SuperNode)items.get(0));
        }
        return true;
    }

    boolean wrapFirstItemInPara(SuperNode item) {
        Node firstItemFirstChild = item.getChildren().get(0);
        ParaNode paraNode = new ParaNode(firstItemFirstChild.getChildren());
        paraNode.setStartIndex(firstItemFirstChild.getStartIndex());
        paraNode.setEndIndex(firstItemFirstChild.getEndIndex());
        item.getChildren().set(0, paraNode);
        return true;
    }

    boolean setListItemIndices() {
        SuperNode listItem = (SuperNode)this.getContext().getValueStack().peek();
        List<Node> children = listItem.getChildren();
        listItem.setStartIndex(children.get(0).getStartIndex());
        listItem.setEndIndex(children.get(children.size() - 1).getEndIndex());
        return true;
    }

    public Rule HtmlBlock() {
        return this.NodeSequence(this.FirstOf(this.HtmlBlockInTags(), this.HtmlComment(), new Object[]{this.HtmlBlockSelfClosing()}), this.push(new HtmlBlockNode(this.ext(65536) ? "" : this.match())), this.OneOrMore(this.BlankLine()));
    }

    public Rule HtmlBlockInTags() {
        StringVar tagName = new StringVar();
        return this.Sequence(this.Test(this.HtmlBlockOpen(tagName)), this.HtmlTagBlock(tagName), new Object[0]);
    }

    @Cached
    public Rule HtmlTagBlock(StringVar tagName) {
        return this.Sequence(this.HtmlBlockOpen(tagName), this.ZeroOrMore(this.FirstOf(this.HtmlTagBlock(tagName), this.Sequence(this.TestNot(this.HtmlBlockClose(tagName)), ANY, new Object[0]), new Object[0])), new Object[]{this.HtmlBlockClose(tagName)});
    }

    public Rule HtmlBlockSelfClosing() {
        StringVar tagName = new StringVar();
        return this.Sequence(Character.valueOf('<'), this.Spn1(), new Object[]{this.DefinedHtmlTagName(tagName), this.Spn1(), this.ZeroOrMore(this.HtmlAttribute()), this.Optional(Character.valueOf('/')), this.Spn1(), Character.valueOf('>')});
    }

    public Rule HtmlBlockOpen(StringVar tagName) {
        return this.Sequence(Character.valueOf('<'), this.Spn1(), new Object[]{this.DefinedHtmlTagName(tagName), this.Spn1(), this.ZeroOrMore(this.HtmlAttribute()), Character.valueOf('>')});
    }

    @DontSkipActionsInPredicates
    public Rule HtmlBlockClose(StringVar tagName) {
        return this.Sequence(Character.valueOf('<'), this.Spn1(), new Object[]{Character.valueOf('/'), this.OneOrMore(this.Alphanumeric()), this.match().equals(tagName.get()), this.Spn1(), Character.valueOf('>')});
    }

    @Cached
    public Rule DefinedHtmlTagName(StringVar tagName) {
        return this.Sequence(this.OneOrMore(this.Alphanumeric()), tagName.isSet() && this.match().equals(tagName.get()) || tagName.isNotSet() && tagName.set((Object)this.match().toLowerCase()) && this.isHtmlTag((String)tagName.get()), new Object[0]);
    }

    public boolean isHtmlTag(String string) {
        return Arrays.binarySearch(HTML_TAGS, string) >= 0;
    }

    public Rule Inlines() {
        return this.NodeSequence(this.InlineOrIntermediateEndline(), this.push(new SuperNode(this.popAsNode())), this.ZeroOrMore(this.InlineOrIntermediateEndline(), this.addAsChild(), new Object[0]), this.Optional(this.Endline(), this.drop(), new Object[0]));
    }

    public Rule InlineOrIntermediateEndline() {
        return this.FirstOf(this.Sequence(this.TestNot(this.Endline()), this.Inline(), new Object[0]), this.Sequence(this.Endline(), this.Test(this.Inline()), new Object[0]), new Object[0]);
    }

    @MemoMismatches
    public Rule Inline() {
        return this.Sequence(this.checkForParsingTimeout(), this.FirstOf(this.Link(), this.NonLinkInline(), new Object[0]), new Object[0]);
    }

    public Rule NonAutoLinkInline() {
        return this.FirstOf(this.NonAutoLink(), this.NonLinkInline(), new Object[0]);
    }

    public Rule NonLinkInline() {
        Rule[] ruleArray;
        Rule[] ruleArray2;
        Rule[] ruleArray3;
        ArrayBuilder arrayBuilder = new ArrayBuilder().add((Object[])this.plugins.getInlinePluginRules()).add((Object[])new Rule[]{this.Str(), this.Endline(), this.UlOrStarLine(), this.Space(), this.StrongOrEmph(), this.Image(), this.Code(), this.InlineHtml(), this.Entity(), this.EscapedChar()});
        if (this.ext(2)) {
            Rule[] ruleArray4 = new Rule[3];
            ruleArray4[0] = this.SingleQuoted();
            ruleArray4[1] = this.DoubleQuoted();
            ruleArray3 = ruleArray4;
            ruleArray4[2] = this.DoubleAngleQuoted();
        } else {
            ruleArray3 = null;
        }
        ArrayBuilder arrayBuilder2 = arrayBuilder.addNonNulls(ruleArray3);
        if (this.ext(1)) {
            Rule[] ruleArray5 = new Rule[1];
            ruleArray2 = ruleArray5;
            ruleArray5[0] = this.Smarts();
        } else {
            ruleArray2 = null;
        }
        ArrayBuilder arrayBuilder3 = arrayBuilder2.addNonNulls(ruleArray2);
        if (this.ext(512)) {
            Rule[] ruleArray6 = new Rule[1];
            ruleArray = ruleArray6;
            ruleArray6[0] = this.Strike();
        } else {
            ruleArray = null;
        }
        return this.FirstOf(arrayBuilder3.addNonNulls(ruleArray).add((Object[])new Rule[]{this.Symbol()}).get());
    }

    @MemoMismatches
    public Rule Endline() {
        return this.NodeSequence(this.FirstOf(this.LineBreak(), this.TerminalEndline(), new Object[]{this.NormalEndline()}));
    }

    public Rule LineBreak() {
        return this.Sequence("  ", this.NormalEndline(), new Object[]{this.poke(new SimpleNode(SimpleNode.Type.Linebreak))});
    }

    public Rule TerminalEndline() {
        return this.NodeSequence(this.Sp(), this.Newline(), this.Test(EOI), this.push(new TextNode("\n")));
    }

    public Rule NormalEndline() {
        return this.Sequence(this.Sp(), this.Newline(), new Object[]{this.TestNot(this.FirstOf(this.BlankLine(), Character.valueOf('>'), new Object[]{this.AtxStart(), this.Sequence(this.ZeroOrMore(this.NotNewline(), ANY, new Object[0]), this.Newline(), new Object[]{this.FirstOf(this.NOrMore('=', 3), this.NOrMore('-', 3), new Object[0]), this.Newline()})})), this.ext(8) ? this.toRule(this.push(new SimpleNode(SimpleNode.Type.Linebreak))) : this.toRule(this.push(new TextNode(" ")))});
    }

    @MemoMismatches
    public Rule UlOrStarLine() {
        return this.NodeSequence(this.FirstOf(this.CharLine('_'), this.CharLine('*'), new Object[]{this.CharLine('~')}), this.push(new TextNode(this.match())));
    }

    public Rule CharLine(char c) {
        return this.FirstOf(this.NOrMore(c, 4), this.Sequence(this.Spacechar(), this.OneOrMore(Character.valueOf(c)), new Object[]{this.Test(this.Spacechar())}), new Object[0]);
    }

    public Rule StrongOrEmph() {
        return this.Sequence(this.Test(this.AnyOf("*_")), this.FirstOf(this.Strong(), this.Emph(), new Object[0]), new Object[0]);
    }

    public Rule Emph() {
        return this.NodeSequence(this.FirstOf(this.EmphOrStrong("*"), this.EmphOrStrong("_"), new Object[0]));
    }

    public Rule Strong() {
        return this.NodeSequence(this.FirstOf(this.EmphOrStrong("**"), this.EmphOrStrong("__"), new Object[0]));
    }

    public Rule Strike() {
        return this.NodeSequence(this.EmphOrStrong("~~"), this.push(new StrikeNode(this.popAsNode().getChildren())));
    }

    @Cached
    public Rule EmphOrStrong(String chars) {
        return this.Sequence(this.Test(this.mayEnterEmphOrStrong(chars)), this.EmphOrStrongOpen(chars), new Object[]{this.push(new StrongEmphSuperNode(chars)), this.OneOrMore(this.TestNot(this.EmphOrStrongClose(chars)), this.Inline(), new Object[]{this.FirstOf(this.Sequence(this.Test(this.isStrongCloseCharStolen(chars)), chars.substring(0, 1), new Object[]{this.TestNot(chars.substring(0, 1)), this.stealBackStrongCloseChar()}), this.addAsChild(), new Object[0])}), this.Optional(this.Sequence(this.EmphOrStrongClose(chars), this.setClosed(), new Object[0]))});
    }

    public Rule EmphOrStrongOpen(String chars) {
        return this.Sequence(this.TestNot(this.CharLine(chars.charAt(0))), chars, new Object[]{this.TestNot(this.Spacechar()), this.NotNewline()});
    }

    @Cached
    public Rule EmphOrStrongClose(String chars) {
        return this.Sequence(this.Test(this.isLegalEmphOrStrongClosePos()), this.FirstOf(this.Sequence(this.Test(ValidEmphOrStrongCloseNode.class.equals(this.peek(0).getClass())), this.drop(), new Object[0]), this.Sequence(this.TestNot(this.Spacechar()), this.NotNewline(), new Object[]{chars, this.FirstOf(chars.length() == 2, this.TestNot(this.Alphanumeric()), new Object[0])}), new Object[0]), new Object[0]);
    }

    protected boolean mayEnterEmphOrStrong(String chars) {
        boolean isStrong;
        if (!this.isLegalEmphOrStrongStartPos()) {
            return false;
        }
        Object parent = this.peek(2);
        boolean bl = isStrong = chars.length() == 2;
        return !StrongEmphSuperNode.class.equals(parent.getClass()) || ((StrongEmphSuperNode)parent).isStrong() != isStrong;
    }

    protected boolean isLegalEmphOrStrongStartPos() {
        if (this.currentIndex() == 0) {
            return true;
        }
        Object lastItem = this.peek(1);
        Class<?> lastClass = lastItem.getClass();
        while (SuperNode.class.isAssignableFrom(lastClass)) {
            SuperNode supernode = (SuperNode)lastItem;
            if (supernode.getChildren().size() < 1) {
                return true;
            }
            lastItem = supernode.getChildren().get(supernode.getChildren().size() - 1);
            lastClass = lastItem.getClass();
        }
        return TextNode.class.equals(lastClass) && ((TextNode)lastItem).getText().endsWith(" ") || SimpleNode.class.equals(lastClass) || Integer.class.equals(lastClass);
    }

    protected boolean setClosed() {
        StrongEmphSuperNode node = (StrongEmphSuperNode)this.peek();
        node.setClosed(true);
        return true;
    }

    protected boolean isStrongCloseCharStolen(String chars) {
        if (chars.length() < 2) {
            return false;
        }
        Class<?> childClass = this.peek().getClass();
        if (StrongEmphSuperNode.class.equals(childClass)) {
            StrongEmphSuperNode child = (StrongEmphSuperNode)this.peek();
            if (!child.isClosed()) {
                return false;
            }
            if (child.getChars().endsWith(chars.substring(0, 1))) {
                return true;
            }
        }
        return false;
    }

    protected boolean stealBackStrongCloseChar() {
        StrongEmphSuperNode child = (StrongEmphSuperNode)this.peek();
        child.setClosed(false);
        this.addAsChild();
        this.push(new ValidEmphOrStrongCloseNode());
        return true;
    }

    protected boolean isLegalEmphOrStrongClosePos() {
        Object lastItem = this.peek();
        if (StrongEmphSuperNode.class.equals(lastItem.getClass())) {
            List<Node> children = ((StrongEmphSuperNode)lastItem).getChildren();
            if (children.size() < 1) {
                return true;
            }
            lastItem = children.get(children.size() - 1);
            Class<?> lastClass = lastItem.getClass();
            if (TextNode.class.equals(lastClass)) {
                return !((TextNode)lastItem).getText().endsWith(" ");
            }
            if (SimpleNode.class.equals(lastClass)) {
                return !((SimpleNode)lastItem).getType().equals((Object)SimpleNode.Type.Linebreak);
            }
        }
        return true;
    }

    public Rule Image() {
        return this.NodeSequence(Character.valueOf('!'), this.Label(), this.FirstOf(this.ExplicitLink(true), this.ReferenceLink(true), new Object[0]));
    }

    @MemoMismatches
    public Rule Link() {
        Rule[] ruleArray;
        Object[] objectArray = new Object[1];
        ArrayBuilder arrayBuilder = new ArrayBuilder();
        if (this.ext(256)) {
            Rule[] ruleArray2 = new Rule[1];
            ruleArray = ruleArray2;
            ruleArray2[0] = this.WikiLink();
        } else {
            ruleArray = null;
        }
        objectArray[0] = this.FirstOf(arrayBuilder.addNonNulls(ruleArray).add((Object[])new Rule[]{this.Sequence(this.Label(), this.FirstOf(this.ExplicitLink(false), this.ReferenceLink(false), new Object[0]), new Object[0])}).add((Object[])new Rule[]{this.AutoLink()}).get());
        return this.NodeSequence(objectArray);
    }

    public Rule NonAutoLink() {
        return this.NodeSequence(this.Sequence(this.Label(), this.FirstOf(this.ExplicitLink(false), this.ReferenceLink(false), new Object[0]), new Object[0]));
    }

    @Cached
    public Rule ExplicitLink(boolean image) {
        return this.Sequence(this.Spn1(), Character.valueOf('('), new Object[]{this.Sp(), this.LinkSource(), this.Spn1(), this.FirstOf(this.LinkTitle(), this.push(""), new Object[0]), this.Sp(), Character.valueOf(')'), this.push(image ? new ExpImageNode(this.popAsString(), this.popAsString(), this.popAsNode()) : new ExpLinkNode(this.popAsString(), this.popAsString(), this.popAsNode()))});
    }

    public Rule ReferenceLink(boolean image) {
        return this.Sequence(this.FirstOf(this.Sequence(this.Spn1(), this.push(this.match()), new Object[]{this.FirstOf(this.Label(), this.Sequence("[]", this.push(null), new Object[0]), new Object[0])}), this.Sequence(this.push(null), this.push(null), new Object[0]), new Object[0]), this.push(image ? new RefImageNode((SuperNode)this.popAsNode(), this.popAsString(), this.popAsNode()) : new RefLinkNode((SuperNode)this.popAsNode(), this.popAsString(), this.popAsNode())), new Object[0]);
    }

    @Cached
    public Rule LinkSource() {
        StringBuilderVar url = new StringBuilderVar();
        return this.FirstOf(this.Sequence(Character.valueOf('('), this.LinkSource(), new Object[]{Character.valueOf(')')}), this.Sequence(Character.valueOf('<'), this.LinkSource(), new Object[]{Character.valueOf('>')}), new Object[]{this.Sequence(this.OneOrMore(this.FirstOf(this.Sequence(Character.valueOf('\\'), this.AnyOf("()"), new Object[]{url.append(this.matchedChar())}), this.Sequence(this.TestNot(this.AnyOf("()>")), this.Nonspacechar(), new Object[]{url.append(this.matchedChar())}), new Object[0])), this.push(url.getString()), new Object[0]), this.push("")});
    }

    public Rule LinkTitle() {
        return this.FirstOf(this.LinkTitle('\''), this.LinkTitle('\"'), new Object[0]);
    }

    public Rule LinkTitle(char delimiter) {
        return this.Sequence(Character.valueOf(delimiter), this.ZeroOrMore(this.TestNot(Character.valueOf(delimiter), this.Sp(), new Object[]{this.FirstOf(Character.valueOf(')'), this.Newline(), new Object[0])}), this.NotNewline(), new Object[]{ANY}), new Object[]{this.push(this.match()), Character.valueOf(delimiter)});
    }

    public Rule AutoLink() {
        return this.Sequence(this.ext(16) ? this.Optional(Character.valueOf('<')) : this.Ch('<'), this.FirstOf(this.AutoLinkUrl(), this.AutoLinkEmail(), new Object[0]), new Object[]{this.ext(16) ? this.Optional(Character.valueOf('>')) : this.Ch('>')});
    }

    public Rule WikiLink() {
        return this.Sequence("[[", this.OneOrMore(this.TestNot(Character.valueOf(']')), ANY, new Object[0]), new Object[]{this.push(new WikiLinkNode(this.match())), "]]"});
    }

    public Rule AutoLinkUrl() {
        return this.Sequence(this.Sequence(this.OneOrMore(this.Letter()), "://", new Object[]{this.AutoLinkEnd()}), this.push(new AutoLinkNode(this.match())), new Object[0]);
    }

    public Rule AutoLinkEmail() {
        return this.Sequence(this.Sequence(this.OneOrMore(this.FirstOf(this.Alphanumeric(), this.AnyOf("-+_."), new Object[0])), Character.valueOf('@'), new Object[]{this.AutoLinkEnd()}), this.push(new MailLinkNode(this.match())), new Object[0]);
    }

    public Rule AutoLinkEnd() {
        return this.OneOrMore(this.TestNot(this.Newline()), this.ext(16) ? this.TestNot(this.FirstOf(this.AnyOf("<>"), this.Sequence(this.Optional(this.AnyOf(".,;:)}]\"'")), this.FirstOf(this.Spacechar(), this.Newline(), new Object[0]), new Object[0]), new Object[0])) : this.TestNot(Character.valueOf('>')), new Object[]{ANY});
    }

    public Rule Label() {
        return this.Sequence(Character.valueOf('['), this.push(new SuperNode()), new Object[]{this.OneOrMore(this.TestNot(Character.valueOf(']')), this.NonAutoLinkInline(), new Object[]{this.addAsChild()}), Character.valueOf(']')});
    }

    public Rule Reference() {
        Var ref = new Var();
        return this.NodeSequence(this.NonindentSpace(), this.Label(), this.push(ref.setAndGet((Object)new ReferenceNode(this.popAsNode()))), Character.valueOf(':'), this.Spn1(), this.RefSrc((Var<ReferenceNode>)ref), this.Sp(), this.Optional(this.RefTitle((Var<ReferenceNode>)ref)), this.Sp(), this.Newline(), this.ZeroOrMore(this.BlankLine()), this.references.add((ReferenceNode)ref.get()));
    }

    public Rule RefSrc(Var<ReferenceNode> ref) {
        return this.FirstOf(this.Sequence(Character.valueOf('<'), this.RefSrcContent(ref), new Object[]{Character.valueOf('>')}), this.RefSrcContent(ref), new Object[0]);
    }

    public Rule RefSrcContent(Var<ReferenceNode> ref) {
        return this.Sequence(this.OneOrMore(this.TestNot(Character.valueOf('>')), this.Nonspacechar(), new Object[0]), ((ReferenceNode)ref.get()).setUrl(this.match()), new Object[0]);
    }

    public Rule RefTitle(Var<ReferenceNode> ref) {
        return this.FirstOf(this.RefTitle('\'', '\'', ref), this.RefTitle('\"', '\"', ref), new Object[]{this.RefTitle('(', ')', ref)});
    }

    public Rule RefTitle(char open, char close, Var<ReferenceNode> ref) {
        return this.Sequence(Character.valueOf(open), this.ZeroOrMore(this.TestNot(Character.valueOf(close), this.Sp(), new Object[]{this.Newline()}), this.NotNewline(), new Object[]{ANY}), new Object[]{((ReferenceNode)ref.get()).setTitle(this.match()), Character.valueOf(close)});
    }

    public Rule Code() {
        return this.NodeSequence(this.Test(Character.valueOf('`')), this.FirstOf(this.Code(this.Ticks(1)), this.Code(this.Ticks(2)), new Object[]{this.Code(this.Ticks(3)), this.Code(this.Ticks(4)), this.Code(this.Ticks(5))}));
    }

    public Rule Code(Rule ticks) {
        return this.Sequence(ticks, this.Sp(), new Object[]{this.OneOrMore(this.FirstOf(this.Sequence(this.TestNot(Character.valueOf('`')), this.Nonspacechar(), new Object[0]), this.Sequence(this.TestNot(ticks), this.OneOrMore(Character.valueOf('`')), new Object[0]), new Object[]{this.Sequence(this.TestNot(this.Sp(), ticks, new Object[0]), this.FirstOf(this.Spacechar(), this.Sequence(this.Newline(), this.TestNot(this.BlankLine()), new Object[0]), new Object[0]), new Object[0])})), this.push(new CodeNode(this.match())), this.Sp(), ticks});
    }

    public Rule Ticks(int count) {
        return this.Sequence(StringUtils.repeat((char)'`', (int)count), this.TestNot(Character.valueOf('`')), new Object[0]);
    }

    public Rule InlineHtml() {
        return this.NodeSequence(this.FirstOf(this.HtmlComment(), this.HtmlTag(), new Object[0]), this.push(new InlineHtmlNode(this.ext(131072) ? "" : this.match())));
    }

    public Rule HtmlComment() {
        return this.Sequence("<!--", this.ZeroOrMore(this.TestNot("-->"), ANY, new Object[0]), new Object[]{"-->"});
    }

    public Rule HtmlTag() {
        return this.Sequence(Character.valueOf('<'), this.Spn1(), new Object[]{this.Optional(Character.valueOf('/')), this.OneOrMore(this.Alphanumeric()), this.Spn1(), this.ZeroOrMore(this.HtmlAttribute()), this.Optional(Character.valueOf('/')), this.Spn1(), Character.valueOf('>')});
    }

    public Rule HtmlAttribute() {
        return this.Sequence(this.OneOrMore(this.FirstOf(this.Alphanumeric(), Character.valueOf('-'), new Object[]{Character.valueOf('_')})), this.Spn1(), new Object[]{this.Optional(Character.valueOf('='), this.Spn1(), new Object[]{this.FirstOf(this.Quoted(), this.OneOrMore(this.TestNot(Character.valueOf('>')), this.Nonspacechar(), new Object[0]), new Object[0])}), this.Spn1()});
    }

    public Rule Quoted() {
        return this.FirstOf(this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.TestNot(Character.valueOf('\"')), ANY, new Object[0]), new Object[]{Character.valueOf('\"')}), this.Sequence(Character.valueOf('\''), this.ZeroOrMore(this.TestNot(Character.valueOf('\'')), ANY, new Object[0]), new Object[]{Character.valueOf('\'')}), new Object[0]);
    }

    public Rule BlankLine() {
        return this.Sequence(this.Sp(), this.Newline(), new Object[0]);
    }

    public Rule Line(StringBuilderVar sb) {
        return this.Sequence(this.Sequence(this.ZeroOrMore(this.NotNewline(), ANY, new Object[0]), this.Newline(), new Object[0]), sb.append(this.match()), new Object[0]);
    }

    public Rule Entity() {
        return this.NodeSequence(this.Sequence(Character.valueOf('&'), this.FirstOf(this.HexEntity(), this.DecEntity(), new Object[]{this.CharEntity()}), new Object[]{Character.valueOf(';')}), this.push(new TextNode(this.match())));
    }

    public Rule HexEntity() {
        return this.Sequence(Character.valueOf('#'), this.IgnoreCase('x'), new Object[]{this.OneOrMore(this.FirstOf(this.Digit(), this.CharRange('a', 'f'), new Object[]{this.CharRange('A', 'F')}))});
    }

    public Rule DecEntity() {
        return this.Sequence(Character.valueOf('#'), this.OneOrMore(this.Digit()), new Object[0]);
    }

    public Rule CharEntity() {
        return this.OneOrMore(this.Alphanumeric());
    }

    public Rule Str() {
        return this.NodeSequence(this.OneOrMore(this.NormalChar()), this.push(new TextNode(this.match())));
    }

    public Rule Space() {
        return this.NodeSequence(this.OneOrMore(this.Spacechar()), this.push(new TextNode(" ")));
    }

    public Rule Spn1() {
        return this.Sequence(this.Sp(), this.Optional(this.Newline(), this.Sp(), new Object[0]), new Object[0]);
    }

    public Rule Sp() {
        return this.ZeroOrMore(this.Spacechar());
    }

    public Rule Spacechar() {
        return this.AnyOf(" \t");
    }

    public Rule Nonspacechar() {
        return this.Sequence(this.TestNot(this.Spacechar()), this.NotNewline(), new Object[]{ANY});
    }

    @MemoMismatches
    public Rule NormalChar() {
        return this.Sequence(this.TestNot(this.SpecialChar()), this.TestNot(this.Spacechar()), new Object[]{this.NotNewline(), ANY});
    }

    public Rule EscapedChar() {
        return this.NodeSequence(Character.valueOf('\\'), this.AnyOf("*_`&[]<>!#\\'\".+-(){}:|~"), this.push(new SpecialTextNode(this.match())));
    }

    public Rule Symbol() {
        return this.NodeSequence(this.SpecialChar(), this.push(new SpecialTextNode(this.match())));
    }

    public Rule SpecialChar() {
        String chars = "*_`&[]<>!#\\";
        if (this.ext(2)) {
            chars = chars + "'\"";
        }
        if (this.ext(1)) {
            chars = chars + ".-";
        }
        if (this.ext(16)) {
            chars = chars + "(){}";
        }
        if (this.ext(64)) {
            chars = chars + ":";
        }
        if (this.ext(32)) {
            chars = chars + "|";
        }
        if (this.ext(64) | this.ext(128)) {
            chars = chars + "~";
        }
        for (Character ch : this.plugins.getSpecialChars()) {
            if (chars.contains(ch.toString())) continue;
            chars = chars + ch;
        }
        return this.AnyOf(chars);
    }

    public Rule NotNewline() {
        return this.TestNot(this.AnyOf("\n\r"));
    }

    public Rule Newline() {
        return this.FirstOf(Character.valueOf('\n'), this.Sequence(Character.valueOf('\r'), this.Optional(Character.valueOf('\n')), new Object[0]), new Object[0]);
    }

    public Rule NonindentSpace() {
        return this.FirstOf("   ", "  ", new Object[]{" ", EMPTY});
    }

    public Rule Indent() {
        return this.FirstOf(Character.valueOf('\t'), "    ", new Object[0]);
    }

    public Rule Alphanumeric() {
        return this.FirstOf(this.Letter(), this.Digit(), new Object[0]);
    }

    public Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[0]);
    }

    public Rule Digit() {
        return this.CharRange('0', '9');
    }

    public Rule Abbreviation() {
        Var node = new Var();
        return this.NodeSequence(this.NonindentSpace(), Character.valueOf('*'), this.Label(), this.push(node.setAndGet((Object)new AbbreviationNode(this.popAsNode()))), this.Sp(), Character.valueOf(':'), this.Sp(), this.AbbreviationText((Var<AbbreviationNode>)node), this.ZeroOrMore(this.BlankLine()), this.abbreviations.add((AbbreviationNode)node.get()));
    }

    public Rule AbbreviationText(Var<AbbreviationNode> node) {
        return this.Sequence(this.NodeSequence(this.push(new SuperNode()), this.ZeroOrMore(this.NotNewline(), this.Inline(), new Object[]{this.addAsChild()})), ((AbbreviationNode)node.get()).setExpansion(this.popAsNode()), new Object[0]);
    }

    public Rule Table() {
        Var node = new Var();
        return this.NodeSequence(this.push(node.setAndGet((Object)new TableNode())), this.Optional(this.NodeSequence(this.TableRow(), this.push(1, new TableHeaderNode()) && this.addAsChild(), this.ZeroOrMore(this.TableRow(), this.addAsChild(), new Object[0])), this.addAsChild(), new Object[0]), this.TableDivider((Var<TableNode>)node), this.Optional(this.NodeSequence(this.TableRow(), this.push(1, new TableBodyNode()) && this.addAsChild(), this.ZeroOrMore(this.TableRow(), this.addAsChild(), new Object[0])), this.addAsChild(), new Object[0]), this.Optional(this.TableCaption(), this.addAsChild(), new Object[0]), !((TableNode)node.get()).getChildren().isEmpty());
    }

    public Rule TableCaption() {
        return this.Sequence(this.CaptionStart(), this.Optional(this.Sp()), new Object[]{this.OneOrMore(this.CaptionInline(), this.addAsChild(), new Object[0]), this.Optional(this.Sp(), this.Optional(Character.valueOf(']')), new Object[]{this.Sp()}), this.Newline()});
    }

    public Rule CaptionStart() {
        return this.Sequence("[", this.push(new TableCaptionNode()), new Object[0]);
    }

    public Rule CaptionInline() {
        return this.Sequence(this.TestNot(this.Newline()), this.TestNot(this.Optional(this.Sp()), this.Optional(Character.valueOf(']')), new Object[]{this.Sp(), this.Newline()}), new Object[]{this.Inline()});
    }

    public Rule TableDivider(Var<TableNode> tableNode) {
        Var pipeSeen = new Var((Object)Boolean.FALSE);
        return this.Sequence(this.Optional(Character.valueOf('|'), pipeSeen.set((Object)Boolean.TRUE), new Object[0]), this.OneOrMore(this.TableColumn(tableNode, (Var<Boolean>)pipeSeen)), new Object[]{(Boolean)pipeSeen.get() != false || ((TableNode)tableNode.get()).hasTwoOrMoreDividers(), this.Sp(), this.Newline()});
    }

    public Rule TableColumn(Var<TableNode> tableNode, Var<Boolean> pipeSeen) {
        Var node = new Var((Object)new TableColumnNode());
        return this.Sequence(this.Sp(), this.Optional(Character.valueOf(':'), ((TableColumnNode)node.get()).markLeftAligned(), new Object[0]), new Object[]{this.Sp(), this.OneOrMore(Character.valueOf('-')), this.Sp(), this.Optional(Character.valueOf(':'), ((TableColumnNode)node.get()).markRightAligned(), new Object[0]), this.Sp(), this.Optional(Character.valueOf('|'), pipeSeen.set((Object)Boolean.TRUE), new Object[0]), ((TableNode)tableNode.get()).addColumn((TableColumnNode)node.get())});
    }

    public Rule TableRow() {
        Var leadingPipe = new Var((Object)Boolean.FALSE);
        return this.NodeSequence(this.push(new TableRowNode()), this.Optional(Character.valueOf('|'), leadingPipe.set((Object)Boolean.TRUE), new Object[0]), this.OneOrMore(this.TableCell(), this.addAsChild(), new Object[0]), (Boolean)leadingPipe.get() != false || ((Node)this.peek()).getChildren().size() > 1 || this.getContext().getInputBuffer().charAt(this.matchEnd() - 1) == '|', this.Sp(), this.Newline());
    }

    public Rule TableCell() {
        return this.NodeSequence(this.push(new TableCellNode()), this.TestNot(this.Sp(), this.Optional(Character.valueOf(':')), new Object[]{this.Sp(), this.OneOrMore(Character.valueOf('-')), this.Sp(), this.Optional(Character.valueOf(':')), this.Sp(), this.FirstOf(Character.valueOf('|'), this.Newline(), new Object[0])}), this.Optional(this.Sp(), this.TestNot(Character.valueOf('|')), new Object[]{this.NotNewline()}), this.OneOrMore(this.TestNot(Character.valueOf('|')), this.TestNot(this.Sp(), this.Newline(), new Object[0]), new Object[]{this.Inline(), this.addAsChild(), this.Optional(this.Sp(), this.Test(Character.valueOf('|')), new Object[]{this.Test(this.Newline())})}), this.ZeroOrMore(Character.valueOf('|')), ((TableCellNode)this.peek()).setColSpan(Math.max(1, this.matchLength())));
    }

    public Rule Smarts() {
        return this.NodeSequence(this.FirstOf(this.Sequence(this.FirstOf("...", ". . .", new Object[0]), this.push(new SimpleNode(SimpleNode.Type.Ellipsis)), new Object[0]), this.Sequence("---", this.push(new SimpleNode(SimpleNode.Type.Emdash)), new Object[0]), new Object[]{this.Sequence("--", this.push(new SimpleNode(SimpleNode.Type.Endash)), new Object[0]), this.Sequence(Character.valueOf('\''), this.push(new SimpleNode(SimpleNode.Type.Apostrophe)), new Object[0])}));
    }

    public Rule SingleQuoted() {
        return this.NodeSequence(!Character.isLetter(this.getContext().getInputBuffer().charAt(this.getContext().getCurrentIndex() - 1)), Character.valueOf('\''), this.push(new QuotedNode(QuotedNode.Type.Single)), this.OneOrMore(this.TestNot(this.SingleQuoteEnd()), this.Inline(), new Object[]{this.addAsChild()}), this.SingleQuoteEnd());
    }

    public Rule SingleQuoteEnd() {
        return this.Sequence(Character.valueOf('\''), this.TestNot(this.Alphanumeric()), new Object[0]);
    }

    public Rule DoubleQuoted() {
        return this.NodeSequence(Character.valueOf('\"'), this.push(new QuotedNode(QuotedNode.Type.Double)), this.OneOrMore(this.TestNot(Character.valueOf('\"')), this.Inline(), new Object[]{this.addAsChild()}), Character.valueOf('\"'));
    }

    public Rule DoubleAngleQuoted() {
        return this.NodeSequence("<<", this.push(new QuotedNode(QuotedNode.Type.DoubleAngle)), this.Optional(this.NodeSequence(this.Spacechar(), this.push(new SimpleNode(SimpleNode.Type.Nbsp))), this.addAsChild(), new Object[0]), this.OneOrMore(this.FirstOf(this.Sequence(this.NodeSequence(this.OneOrMore(this.Spacechar()), this.Test(">>"), this.push(new SimpleNode(SimpleNode.Type.Nbsp))), this.addAsChild(), new Object[0]), this.Sequence(this.TestNot(">>"), this.Inline(), new Object[]{this.addAsChild()}), new Object[0])), ">>");
    }

    public Rule NOrMore(char c, int n) {
        return this.Sequence(StringUtils.repeat((char)c, (int)n), this.ZeroOrMore(Character.valueOf(c)), new Object[0]);
    }

    public Rule NodeSequence(Object ... nodeRules) {
        return this.Sequence(this.push(this.getContext().getCurrentIndex()), this.Sequence(nodeRules), new Object[]{this.setIndices()});
    }

    public boolean setIndices() {
        AbstractNode node = (AbstractNode)this.peek();
        node.setStartIndex((Integer)this.pop(1));
        node.setEndIndex(this.currentIndex());
        return true;
    }

    public boolean addAsChild() {
        Node lastChild;
        SuperNode parent = (SuperNode)this.peek(1);
        List<Node> children = parent.getChildren();
        Node child = this.popAsNode();
        if (child.getClass() == TextNode.class && !children.isEmpty() && (lastChild = children.get(children.size() - 1)).getClass() == TextNode.class) {
            TextNode last = (TextNode)lastChild;
            TextNode current = (TextNode)child;
            last.append(current.getText());
            last.setEndIndex(current.getEndIndex());
            return true;
        }
        children.add(child);
        return true;
    }

    public Node popAsNode() {
        return (Node)this.pop();
    }

    public String popAsString() {
        return (String)this.pop();
    }

    public boolean ext(int extension) {
        return (this.options & extension) > 0;
    }

    public RootNode parseInternal(StringBuilderVar block) {
        char[] chars = block.getChars();
        int[] ixMap = new int[chars.length + 1];
        StringBuilder clean = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\uffff') continue;
            ixMap[clean.length()] = i;
            clean.append(c);
        }
        ixMap[clean.length()] = chars.length;
        char[] cleaned = new char[clean.length()];
        clean.getChars(0, cleaned.length, cleaned, 0);
        RootNode rootNode = this.parseInternal(cleaned);
        this.fixIndices(rootNode, ixMap);
        return rootNode;
    }

    protected void fixIndices(Node node, int[] ixMap) {
        ((AbstractNode)node).mapIndices(ixMap);
        for (Node subNode : node.getChildren()) {
            this.fixIndices(subNode, ixMap);
        }
    }

    public RootNode parseInternal(char[] source) {
        ParsingResult<Node> result = this.parseToParsingResult(source);
        if (result.hasErrors()) {
            throw new RuntimeException("Internal error during markdown parsing:\n--- ParseErrors ---\n" + ErrorUtils.printParseErrors(result));
        }
        return (RootNode)result.resultValue;
    }

    ParsingResult<Node> parseToParsingResult(char[] source) {
        this.parsingStartTimeStamp = System.currentTimeMillis();
        return this.parseRunnerProvider.get(this.Root()).run(source);
    }

    protected boolean checkForParsingTimeout() {
        if (System.currentTimeMillis() - this.parsingStartTimeStamp > this.maxParsingTimeInMillis) {
            throw new ParsingTimeoutException();
        }
        return true;
    }

    protected static interface SuperNodeCreator {
        public SuperNode create(Node var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParseRunnerProvider {
        public ParseRunner<Node> get(Rule var1);
    }
}

