/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.impl.request;

import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.request.DeployRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.request.UpdateRequest;
import org.jboss.forge.furnace.manager.spi.AddonInfo;

class UpdateRequestImpl
implements UpdateRequest {
    private final RemoveRequest removeRequest;
    private final DeployRequest deployRequest;

    public UpdateRequestImpl(RemoveRequest removeRequest, DeployRequest deployRequest) {
        this.removeRequest = removeRequest;
        this.deployRequest = deployRequest;
    }

    public AddonInfo getRequestedAddonInfo() {
        return this.deployRequest.getRequestedAddonInfo();
    }

    public DeployRequest getDeployRequest() {
        return this.deployRequest;
    }

    public RemoveRequest getRemoveRequest() {
        return this.removeRequest;
    }

    public void perform() {
        this.removeRequest.perform();
        this.deployRequest.perform();
    }

    public String toString() {
        AddonId oldAddon = this.removeRequest.getRequestedAddonInfo().getAddon();
        AddonId newAddon = this.deployRequest.getRequestedAddonInfo().getAddon();
        if (oldAddon.getVersion().equals(newAddon.getVersion())) {
            return "Update: [" + newAddon + "]";
        }
        return "Update: from [" + oldAddon + "] to [" + newAddon + "]";
    }
}

