/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.config.HintBuilderIn;
import org.jboss.windup.reporting.config.HintBuilderTitle;
import org.jboss.windup.reporting.config.HintEffort;
import org.jboss.windup.reporting.config.HintLink;
import org.jboss.windup.reporting.config.HintSeverity;
import org.jboss.windup.reporting.config.HintText;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Hint
extends ParameterizedIterationOperation<FileLocationModel>
implements HintText,
HintLink,
HintSeverity,
HintEffort {
    private static final Logger log = Logger.getLogger(Hint.class.getName());
    public static final Severity DEFAULT_SEVERITY = Severity.OPTIONAL;
    private RegexParameterizedPatternParser hintTitlePattern;
    private RegexParameterizedPatternParser hintTextPattern;
    private int effort;
    private Severity severity = DEFAULT_SEVERITY;
    private List<Link> links = new ArrayList<Link>();
    private Set<String> tags = Collections.EMPTY_SET;

    protected Hint(String variable) {
        super(variable);
    }

    protected Hint() {
    }

    public static HintBuilderIn in(String fileVariable) {
        return new HintBuilderIn(fileVariable);
    }

    public static HintBuilderTitle titled(String title) {
        return new HintBuilderTitle(title);
    }

    @Override
    public HintSeverity withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public static HintText withText(String text) {
        Assert.notNull((Object)text, (String)"Hint text must not be null.");
        Hint hint = new Hint();
        hint.setText(text);
        return hint;
    }

    public void performParameterized(GraphRewrite event, EvaluationContext context, FileLocationModel locationModel) {
        GraphService service = new GraphService(event.getGraphContext(), InlineHintModel.class);
        InlineHintModel hintModel = (InlineHintModel)service.create();
        hintModel.setRuleID(((Rule)context.get(Rule.class)).getId());
        hintModel.setLineNumber(locationModel.getLineNumber());
        hintModel.setColumnNumber(locationModel.getColumnNumber());
        hintModel.setLength(locationModel.getLength());
        hintModel.setFileLocationReference(locationModel);
        hintModel.setFile(locationModel.getFile());
        hintModel.setEffort(this.effort);
        hintModel.setSeverity(this.severity);
        if (this.hintTitlePattern != null) {
            hintModel.setTitle(this.hintTitlePattern.getBuilder().build((Rewrite)event, context));
        } else {
            hintModel.setTitle(locationModel.getDescription());
        }
        String hintText = this.hintTextPattern.getBuilder().build((Rewrite)event, context);
        hintModel.setHint(hintText);
        GraphService linkService = new GraphService(event.getGraphContext(), LinkModel.class);
        for (Link link : this.links) {
            LinkModel linkModel = (LinkModel)linkService.create();
            linkModel.setDescription(link.getTitle());
            linkModel.setLink(link.getLink());
            hintModel.addLink(linkModel);
        }
        hintModel.setTags(this.getTags());
        if (locationModel.getFile() instanceof SourceFileModel) {
            ((SourceFileModel)locationModel.getFile()).setGenerateSourceReport(true);
        }
        log.info("Hint added to " + locationModel.getFile().getPrettyPathWithinProject() + " [" + this.toString(hintModel.getTitle(), hintText) + "] ");
        log.info("Tags: " + StringUtils.join(this.getTags(), (String)" "));
    }

    @Override
    public HintEffort withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    @Override
    public OperationBuilder withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public HintLink with(Link link) {
        this.links.add(link);
        return this;
    }

    protected void setText(String text) {
        this.hintTextPattern = new RegexParameterizedPatternParser(text);
    }

    protected void setTitle(String title) {
        this.hintTitlePattern = new RegexParameterizedPatternParser(title);
    }

    public RegexParameterizedPatternParser getHintText() {
        return this.hintTextPattern;
    }

    public int getEffort() {
        return this.effort;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.hintTextPattern.getRequiredParameterNames());
        if (this.hintTitlePattern != null) {
            result.addAll(this.hintTitlePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.hintTextPattern.setParameterStore(store);
        if (this.hintTitlePattern != null) {
            this.hintTitlePattern.setParameterStore(store);
        }
    }

    public String toString() {
        String title = "";
        if (this.hintTitlePattern != null) {
            title = this.hintTitlePattern.getPattern();
        }
        return this.toString(title, this.hintTextPattern.getPattern());
    }

    private String toString(String title, String text) {
        StringBuilder result = new StringBuilder();
        result.append("Hint");
        if (title != null) {
            result.append(".titled(\"").append(title).append("\")");
        }
        result.append(".withText(\"").append(text).append("\")");
        if (this.effort != 0) {
            result.append(".withEffort(").append(this.effort).append(")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(").append(this.links).append(")");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            result.append(".withTags(").append(this.tags).append(")");
        }
        return result.toString();
    }
}

