/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.exec.updater.RulesetsUpdater;

@Singleton
public class RulesetUpdateChecker {
    @Inject
    Furnace furnace;

    public void perform(@Observes PostStartup event) {
        if (!event.getAddon().getId().getName().contains("org.jboss.windup.ui:windup-ui")) {
            return;
        }
        RulesetsUpdater updater = (RulesetsUpdater)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(RulesetsUpdater.class).get();
        if (!event.getAddon().getRepository().isDeployed(AddonId.from((String)"org.jboss.windup.exec:windup-exec", (Version)event.getAddon().getId().getVersion()))) {
            throw new IllegalStateException("windup-exec is not deployed.");
        }
        if (updater.rulesetsNeedUpdate()) {
            System.out.println("\nThe rulesets are outdated: " + updater.getRulesetsDir() + "\nConsider running Windup with --updateRuleset or --updateDistribution.\n");
        }
    }
}

