/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.exec.updater.RulesetsUpdater;
import org.jboss.windup.ui.DistributionUpdater;

public class WindupUpdateDistributionCommand
implements UICommand {
    @Inject
    Addon currentAddon;
    @Inject
    private DependencyResolver dependencyResolver;
    @Inject
    private RulesetsUpdater updater;
    @Inject
    private DistributionUpdater distUpdater;

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Update Distribution").description("Update the whole windup installation").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Version installedVersion;
        if (!context.getPrompt().promptBoolean("Are you sure you want to continue? This command will delete current directories: addons, bin, lib, rules/migration-core")) {
            return Results.fail((String)"Updating distribution was aborted.");
        }
        Coordinate latestDist = this.updater.getLatestReleaseOf("org.jboss.windup", "windup-distribution");
        SingleVersion latestVersion = new SingleVersion(latestDist.getVersion());
        if (latestVersion.compareTo((Object)(installedVersion = this.currentAddon.getId().getVersion())) <= 0) {
            return Results.fail((String)"Windup is already in the most updated version.");
        }
        this.distUpdater.replaceWindupDirectoryWithDistribution(latestDist);
        return Results.success((String)("Sucessfully updated Windup to version " + latestDist.getVersion() + ". Please restart Windup."));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public void validate(UIValidationContext context) {
    }
}

