/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.model.PackageModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;

public class ZipEntryPackageFilter
implements Filter<ZipEntry> {
    private static final Logger log = Logging.get(ZipEntryPackageFilter.class);
    private final WindupJavaConfigurationService configurationService;

    public ZipEntryPackageFilter(GraphContext context) {
        this.configurationService = new WindupJavaConfigurationService(context);
    }

    private Set<String> convertToStringFilters(Iterable<PackageModel> packages) {
        HashSet<String> result = new HashSet<String>();
        for (PackageModel model : packages) {
            String packageName = model.getPackageName();
            String entryFilter = StringUtils.replace((String)packageName, (String)".", (String)"/");
            result.add(entryFilter);
        }
        return result;
    }

    public Filter.Result decide(ZipEntry entry) {
        return this.configurationService.shouldScanFile(entry.getName()) ? Filter.Result.ACCEPT : Filter.Result.REJECT;
    }
}

