/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.MetaAnnotatable;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.CustomizeStoreKCVSManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSManagerProxy;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl.TTLKCVS;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TTLKVCSManager
extends KCVSManagerProxy
implements CustomizeStoreKCVSManager {
    private final StoreFeatures features;
    private final Map<String, Integer> ttlEnabledStores;
    private final int defaultTTL;

    public TTLKVCSManager(KeyColumnValueStoreManager manager, int defaultTTL) {
        super(manager);
        Preconditions.checkArgument((boolean)TTLKVCSManager.supportsStoreTTL(manager), (String)"Wrapped store must support cell or store level TTL: %s", (Object[])new Object[]{manager});
        Preconditions.checkArgument((defaultTTL > 0 ? 1 : 0) != 0, (String)"Default TTL must b > 0: %s", (Object[])new Object[]{defaultTTL});
        Preconditions.checkArgument((!manager.getFeatures().hasStoreTTL() || manager instanceof CustomizeStoreKCVSManager ? 1 : 0) != 0);
        this.defaultTTL = defaultTTL;
        this.features = new StandardStoreFeatures.Builder(manager.getFeatures()).storeTTL(true).build();
        this.ttlEnabledStores = Maps.newHashMap();
    }

    public static boolean supportsStoreTTL(KeyColumnValueStoreManager manager) {
        return TTLKVCSManager.supportsStoreTTL(manager.getFeatures());
    }

    public static boolean supportsStoreTTL(StoreFeatures features) {
        return features.hasCellTTL() || features.hasStoreTTL();
    }

    public synchronized void setTTL(String storeName, int ttl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)storeName));
        Preconditions.checkArgument((ttl > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.ttlEnabledStores.containsKey(storeName) ? 1 : 0) != 0, (String)"A TTL has already been set for store: %s", (Object[])new Object[]{storeName});
        this.ttlEnabledStores.put(storeName, ttl);
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.features;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name) throws BackendException {
        return this.openDatabase(name, this.getTTL(name));
    }

    @Override
    public KeyColumnValueStore openDatabase(String name, int ttlInSeconds) throws BackendException {
        if (this.manager.getFeatures().hasStoreTTL()) {
            return ((CustomizeStoreKCVSManager)this.manager).openDatabase(name, ttlInSeconds);
        }
        assert (this.manager.getFeatures().hasCellTTL());
        KeyColumnValueStore store = this.manager.openDatabase(name);
        return new TTLKCVS(store, ttlInSeconds);
    }

    private final int getTTL(String storeName) {
        int ttl = this.defaultTTL;
        if (this.ttlEnabledStores.containsKey(storeName)) {
            ttl = this.ttlEnabledStores.get(storeName);
        }
        return ttl;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        if (!this.manager.getFeatures().hasStoreTTL()) {
            assert (this.manager.getFeatures().hasCellTTL());
            for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> sentry : mutations.entrySet()) {
                Integer ttl = this.ttlEnabledStores.get(sentry.getKey());
                if (ttl == null) continue;
                for (KCVMutation mut : sentry.getValue().values()) {
                    if (!mut.hasAdditions()) continue;
                    TTLKVCSManager.applyTTL(mut.getAdditions(), ttl);
                }
            }
        }
        this.manager.mutateMany(mutations, txh);
    }

    public static void applyTTL(Collection<Entry> additions, int ttl) {
        for (Entry entry : additions) {
            assert (entry instanceof MetaAnnotatable);
            ((MetaAnnotatable)((Object)entry)).setMetaData(EntryMetaData.TTL, ttl);
        }
    }
}

