/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import javax.lang.model.type.TypeKind;

final class ArrayType<T>
extends Type<T> {
    private final Type<?> _elementType;
    private final Class<T> _erasedClass;
    private final FieldList _fields = FieldList.empty();
    private final MethodList _methods = MethodList.empty();

    ArrayType(Type<?> elementType) {
        this._elementType = (Type)VerifyArgument.notNull(elementType, (String)"elementType");
        this._erasedClass = Array.newInstance(elementType.getErasedClass(), 0).getClass();
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public Class<T> getErasedClass() {
        return this._erasedClass;
    }

    @Override
    public Type getElementType() {
        return this._elementType;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return this._elementType.isGenericType();
    }

    @Override
    public Type getGenericTypeDefinition() {
        if (this._elementType.isGenericTypeDefinition()) {
            return this;
        }
        return this._elementType.getGenericTypeDefinition().makeArrayType();
    }

    @Override
    public TypeBindings getTypeBindings() {
        return this._elementType.getTypeBindings();
    }

    @Override
    public Type getDeclaringType() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    protected MethodList getDeclaredMethods() {
        return this._methods;
    }

    @Override
    public FieldList getDeclaredFields() {
        return this._fields;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        sb.append('[');
        return this._elementType.appendSignature(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._elementType.appendErasedSignature(sb.append('['));
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        return this._elementType.appendBriefDescription(sb).append("[]");
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        return this._elementType.appendSimpleDescription(sb).append("[]");
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitArrayType(this, parameter);
    }
}

