/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.reflection.emit.OperandType;

public enum OpCode {
    NOP(0),
    ACONST_NULL(1),
    ICONST_M1(2),
    ICONST_0(3),
    ICONST_1(4),
    ICONST_2(5),
    ICONST_3(6),
    ICONST_4(7),
    ICONST_5(8),
    LCONST_0(9),
    LCONST_1(10),
    FCONST_0(11),
    FCONST_1(12),
    FCONST_2(13),
    DCONST_0(14),
    DCONST_1(15),
    BIPUSH(16, OperandType.Byte),
    SIPUSH(17, OperandType.Short),
    LDC(18, OperandType.CPRef),
    LDC_W(19, OperandType.CPRefWide),
    LDC2_W(20, OperandType.CPRefWide),
    ILOAD(21, OperandType.Local),
    LLOAD(22, OperandType.Local),
    FLOAD(23, OperandType.Local),
    DLOAD(24, OperandType.Local),
    ALOAD(25, OperandType.Local),
    ILOAD_0(26),
    ILOAD_1(27),
    ILOAD_2(28),
    ILOAD_3(29),
    LLOAD_0(30),
    LLOAD_1(31),
    LLOAD_2(32),
    LLOAD_3(33),
    FLOAD_0(34),
    FLOAD_1(35),
    FLOAD_2(36),
    FLOAD_3(37),
    DLOAD_0(38),
    DLOAD_1(39),
    DLOAD_2(40),
    DLOAD_3(41),
    ALOAD_0(42),
    ALOAD_1(43),
    ALOAD_2(44),
    ALOAD_3(45),
    IALOAD(46),
    LALOAD(47),
    FALOAD(48),
    DALOAD(49),
    AALOAD(50),
    BALOAD(51),
    CALOAD(52),
    SALOAD(53),
    ISTORE(54, OperandType.Local),
    LSTORE(55, OperandType.Local),
    FSTORE(56, OperandType.Local),
    DSTORE(57, OperandType.Local),
    ASTORE(58, OperandType.Local),
    ISTORE_0(59),
    ISTORE_1(60),
    ISTORE_2(61),
    ISTORE_3(62),
    LSTORE_0(63),
    LSTORE_1(64),
    LSTORE_2(65),
    LSTORE_3(66),
    FSTORE_0(67),
    FSTORE_1(68),
    FSTORE_2(69),
    FSTORE_3(70),
    DSTORE_0(71),
    DSTORE_1(72),
    DSTORE_2(73),
    DSTORE_3(74),
    ASTORE_0(75),
    ASTORE_1(76),
    ASTORE_2(77),
    ASTORE_3(78),
    IASTORE(79),
    LASTORE(80),
    FASTORE(81),
    DASTORE(82),
    AASTORE(83),
    BASTORE(84),
    CASTORE(85),
    SASTORE(86),
    POP(87),
    POP2(88),
    DUP(89),
    DUP_X1(90),
    DUP_X2(91),
    DUP2(92),
    DUP2_X1(93),
    DUP2_X2(94),
    SWAP(95),
    IADD(96),
    LADD(97),
    FADD(98),
    DADD(99),
    ISUB(100),
    LSUB(101),
    FSUB(102),
    DSUB(103),
    IMUL(104),
    LMUL(105),
    FMUL(106),
    DMUL(107),
    IDIV(108),
    LDIV(109),
    FDIV(110),
    DDIV(111),
    IREM(112),
    LREM(113),
    FREM(114),
    DREM(115),
    INEG(116),
    LNEG(117),
    FNEG(118),
    DNEG(119),
    ISHL(120),
    LSHL(121),
    ISHR(122),
    LSHR(123),
    IUSHR(124),
    LUSHR(125),
    IAND(126),
    LAND(127),
    IOR(128),
    LOR(129),
    IXOR(130),
    LXOR(131),
    IINC(132, OperandType.LocalByte),
    I2L(133),
    I2F(134),
    I2D(135),
    L2I(136),
    L2F(137),
    L2D(138),
    F2I(139),
    F2L(140),
    F2D(141),
    D2I(142),
    D2L(143),
    D2F(144),
    I2B(145),
    I2C(146),
    I2S(147),
    LCMP(148),
    FCMPL(149),
    FCMPG(150),
    DCMPL(151),
    DCMPG(152),
    IFEQ(153, OperandType.Branch),
    IFNE(154, OperandType.Branch),
    IFLT(155, OperandType.Branch),
    IFGE(156, OperandType.Branch),
    IFGT(157, OperandType.Branch),
    IFLE(158, OperandType.Branch),
    IF_ICMPEQ(159, OperandType.Branch),
    IF_ICMPNE(160, OperandType.Branch),
    IF_ICMPLT(161, OperandType.Branch),
    IF_ICMPGE(162, OperandType.Branch),
    IF_ICMPGT(163, OperandType.Branch),
    IF_ICMPLE(164, OperandType.Branch),
    IF_ACMPEQ(165, OperandType.Branch),
    IF_ACMPNE(166, OperandType.Branch),
    GOTO(167, OperandType.Branch),
    JSR(168, OperandType.Branch),
    RET(169, OperandType.Local),
    TABLESWITCH(170, OperandType.Dynamic),
    LOOKUPSWITCH(171, OperandType.Dynamic),
    IRETURN(172),
    LRETURN(173),
    FRETURN(174),
    DRETURN(175),
    ARETURN(176),
    RETURN(177),
    GETSTATIC(178, OperandType.CPRefWide),
    PUTSTATIC(179, OperandType.CPRefWide),
    GETFIELD(180, OperandType.CPRefWide),
    PUTFIELD(181, OperandType.CPRefWide),
    INVOKEVIRTUAL(182, OperandType.CPRefWide),
    INVOKESPECIAL(183, OperandType.CPRefWide),
    INVOKESTATIC(184, OperandType.CPRefWide),
    INVOKEINTERFACE(185, OperandType.CPRefWideUByteZero),
    INVOKEDYNAMIC(186, OperandType.CPRefWideUByteZero),
    NEW(187, OperandType.CPRefWide),
    NEWARRAY(188, OperandType.Type),
    ANEWARRAY(189, OperandType.CPRefWide),
    ARRAYLENGTH(190),
    ATHROW(191),
    CHECKCAST(192, OperandType.CPRefWide),
    INSTANCEOF(193, OperandType.CPRefWide),
    MONITORENTER(194),
    MONITOREXIT(195),
    MULTIANEWARRAY(197, OperandType.CPRefWideUByte),
    IFNULL(198, OperandType.Branch),
    IFNONNULL(199, OperandType.Branch),
    GOTO_W(200, OperandType.BranchW),
    JSR_W(201, OperandType.BranchW),
    BREAKPOINT(201, OperandType.NoOperands),
    ILOAD_W(50197, OperandType.WideCPRefWide),
    LLOAD_W(50198, OperandType.WideCPRefWide),
    FLOAD_W(50199, OperandType.WideCPRefWide),
    DLOAD_W(50200, OperandType.WideCPRefWide),
    ALOAD_W(50201, OperandType.WideCPRefWide),
    ISTORE_W(50230, OperandType.WideCPRefWide),
    LSTORE_W(50231, OperandType.WideCPRefWide),
    FSTORE_W(50232, OperandType.WideCPRefWide),
    DSTORE_W(50233, OperandType.WideCPRefWide),
    ASTORE_W(50234, OperandType.WideCPRefWide),
    IINC_W(50308, OperandType.WideCPRefWideShort),
    RET_W(50345, OperandType.WideCPRefWide);

    private final int _code;
    private final OperandType _operandType;
    public static final int STANDARD = 0;
    public static final int WIDE = 196;
    private static OpCode[] _standardOpCodes;
    private static OpCode[] _wideOpCodes;
    private static final byte[] stackChange;

    private OpCode(int code) {
        this(code, OperandType.NoOperands);
    }

    private OpCode(int code, OperandType operandType) {
        this._code = code;
        this._operandType = operandType;
    }

    public int getCode() {
        return this._code;
    }

    public boolean isWide() {
        return (this._code >> 8 & 0xC4) == 196;
    }

    public OperandType getOperandType() {
        return this._operandType;
    }

    public int getSize() {
        return this._code >> 8 == 196 ? 2 : 1;
    }

    public int getSizeWithOperands() {
        return this._operandType.length;
    }

    public int getStackChange() {
        return stackChange[this._code & 0xFF];
    }

    public OpCode negate() {
        if (this == IFNULL) {
            return IFNONNULL;
        }
        if (this == IFNONNULL) {
            return IFNULL;
        }
        return OpCode.get((this._code + 1 ^ 1) - 1);
    }

    public static OpCode get(int code) {
        return OpCode.getOpcodeBlock(code >> 8)[code & 0xFF];
    }

    private static OpCode[] getOpcodeBlock(int prefix) {
        switch (prefix) {
            case 0: {
                return _standardOpCodes;
            }
            case 196: {
                return _wideOpCodes;
            }
        }
        return null;
    }

    public boolean endsUnconditionalJumpBlock() {
        switch (this) {
            case GOTO: 
            case JSR: 
            case RET: {
                return true;
            }
            case IRETURN: 
            case LRETURN: 
            case FRETURN: 
            case DRETURN: 
            case ARETURN: 
            case RETURN: {
                return true;
            }
            case ATHROW: {
                return true;
            }
            case GOTO_W: 
            case JSR_W: {
                return true;
            }
            case RET_W: {
                return true;
            }
        }
        return false;
    }

    static {
        _standardOpCodes = new OpCode[256];
        _wideOpCodes = new OpCode[256];
        OpCode[] arr$ = OpCode.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            OpCode o;
            OpCode.getOpcodeBlock((int)(o._code >> 8))[o._code & 0xFF] = o = arr$[i$];
        }
        stackChange = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1, -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -3, -4, -3, -4, -3, -3, -3, -3, -1, -2, 1, 1, 1, 2, 2, 2, 0, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -2, 0, 1, 0, 1, -1, -1, 0, 0, 1, 1, -1, 0, -1, 0, 0, 0, -3, -1, -1, -3, -3, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, 0, 1, 0, -1, -1, -1, -2, -1, -2, -1, 0, 1, -1, 1, -1, -1, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, 0, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

