/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.LambdaProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedClassProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedMemberAccess;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ClassesProcessor {
    public static final int AVERAGE_CLASS_SIZE = 16384;
    private final Map<String, ClassNode> mapRootClasses = new HashMap<String, ClassNode>();

    public ClassesProcessor(StructContext context) {
        HashMap<String, Object[]> mapInnerClasses = new HashMap<String, Object[]>();
        HashMap<String, HashSet<String>> mapNestedClassReferences = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> mapEnclosingClassReferences = new HashMap<String, HashSet<String>>();
        HashMap<String, String> mapNewSimpleNames = new HashMap<String, String>();
        boolean bDecompileInner = DecompilerContext.getOption("din");
        for (StructClass structClass : context.getClasses().values()) {
            StructInnerClassesAttribute inner;
            if (!structClass.isOwn() || this.mapRootClasses.containsKey(structClass.qualifiedName)) continue;
            if (bDecompileInner && (inner = (StructInnerClassesAttribute)structClass.getAttributes().getWithKey("InnerClasses")) != null) {
                for (int i = 0; i < inner.getClassEntries().size(); ++i) {
                    StructClass enclosing_class;
                    IIdentifierRenamer renamer;
                    int[] entry = inner.getClassEntries().get(i);
                    String[] strentry = inner.getStringEntries().get(i);
                    Object[] arr = new Object[4];
                    String innername = strentry[0];
                    arr[2] = entry[1] == 0 ? (entry[2] == 0 ? 2 : 4) : 1;
                    String simpleName = strentry[2];
                    String savedName = (String)mapNewSimpleNames.get(innername);
                    if (savedName != null) {
                        simpleName = savedName;
                    } else if (simpleName != null && DecompilerContext.getOption("ren") && (renamer = DecompilerContext.getPoolInterceptor().getHelper()).toBeRenamed(IIdentifierRenamer.Type.ELEMENT_CLASS, simpleName, null, null)) {
                        simpleName = renamer.getNextClassName(innername, simpleName);
                        mapNewSimpleNames.put(innername, simpleName);
                    }
                    arr[1] = simpleName;
                    arr[3] = entry[3];
                    String enclClassName = entry[1] != 0 ? strentry[1] : structClass.qualifiedName;
                    if (innername.equals(enclClassName) || (enclosing_class = context.getClasses().get(enclClassName)) == null || !enclosing_class.isOwn()) continue;
                    Object[] arrold = (Object[])mapInnerClasses.get(innername);
                    if (arrold == null) {
                        mapInnerClasses.put(innername, arr);
                    } else if (!InterpreterUtil.equalObjectArrays(arrold, arr)) {
                        String message = "Inconsistent inner class entries for " + innername + "!";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                    }
                    HashSet<String> set = (HashSet<String>)mapNestedClassReferences.get(enclClassName);
                    if (set == null) {
                        set = new HashSet<String>();
                        mapNestedClassReferences.put(enclClassName, set);
                    }
                    set.add(innername);
                    set = (HashSet<String>)mapEnclosingClassReferences.get(innername);
                    if (set == null) {
                        set = new HashSet<String>();
                        mapEnclosingClassReferences.put(innername, set);
                    }
                    set.add(enclClassName);
                }
            }
            ClassNode node = new ClassNode(0, structClass);
            node.access = structClass.getAccessFlags();
            this.mapRootClasses.put(structClass.qualifiedName, node);
        }
        if (bDecompileInner) {
            for (Map.Entry entry : this.mapRootClasses.entrySet()) {
                if (mapInnerClasses.containsKey(entry.getKey())) continue;
                HashSet<Object> setVisited = new HashSet<Object>();
                LinkedList<Object> stack = new LinkedList<Object>();
                stack.add(entry.getKey());
                setVisited.add(entry.getKey());
                while (!stack.isEmpty()) {
                    String superClass = (String)stack.removeFirst();
                    ClassNode supernode = this.mapRootClasses.get(superClass);
                    HashSet setNestedClasses = (HashSet)mapNestedClassReferences.get(superClass);
                    if (setNestedClasses == null) continue;
                    StructClass scl = supernode.classStruct;
                    StructInnerClassesAttribute inner = (StructInnerClassesAttribute)scl.getAttributes().getWithKey("InnerClasses");
                    for (int i = 0; i < inner.getStringEntries().size(); ++i) {
                        String nestedClass = inner.getStringEntries().get(i)[0];
                        if (!setNestedClasses.contains(nestedClass) || !setVisited.add(nestedClass)) continue;
                        ClassNode nestednode = this.mapRootClasses.get(nestedClass);
                        if (nestednode == null) {
                            DecompilerContext.getLogger().writeMessage("Nested class " + nestedClass + " missing!", IFernflowerLogger.Severity.WARN);
                            continue;
                        }
                        Object[] arr = (Object[])mapInnerClasses.get(nestedClass);
                        nestednode.type = (Integer)arr[2];
                        nestednode.simpleName = (String)arr[1];
                        nestednode.access = (Integer)arr[3];
                        if (nestednode.type == 2) {
                            StructClass cl = nestednode.classStruct;
                            nestednode.access &= 0xFFFFFFF7;
                            int[] interfaces = cl.getInterfaces();
                            if (interfaces.length > 0) {
                                if (interfaces.length > 1) {
                                    String message = "Inconsistent anonymous class definition: " + cl.qualifiedName;
                                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                                }
                                nestednode.anonymousClassType = new VarType(cl.getInterface(0), true);
                            } else {
                                nestednode.anonymousClassType = new VarType(cl.superClass.getString(), true);
                            }
                        } else if (nestednode.type == 4) {
                            nestednode.access &= 0x410;
                        }
                        supernode.nested.add(nestednode);
                        nestednode.parent = supernode;
                        nestednode.enclosingClasses.addAll((Collection)mapEnclosingClassReferences.get(nestedClass));
                        stack.add(nestedClass);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClass(StructClass cl, TextBuffer buffer) throws IOException {
        ClassNode root = this.mapRootClasses.get(cl.qualifiedName);
        if (root.type != 0) {
            return;
        }
        DecompilerContext.getLogger().startReadingClass(cl.qualifiedName);
        try {
            int import_lines_written;
            ImportCollector importCollector = new ImportCollector(root);
            DecompilerContext.setImportCollector(importCollector);
            DecompilerContext.setCounterContainer(new CounterContainer());
            DecompilerContext.setBytecodeSourceMapper(new BytecodeSourceMapper());
            new LambdaProcessor().processClass(root);
            ClassesProcessor.addClassnameToImport(root, importCollector);
            ClassesProcessor.initWrappers(root);
            new NestedClassProcessor().processClass(root, root);
            new NestedMemberAccess().propagateMemberAccess(root);
            TextBuffer classBuffer = new TextBuffer(16384);
            new ClassWriter().classToJava(root, classBuffer, 0, null);
            int total_offset_lines = 0;
            int index = cl.qualifiedName.lastIndexOf("/");
            if (index >= 0) {
                total_offset_lines += 2;
                String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
                buffer.append("package ");
                buffer.append(packageName);
                buffer.append(";");
                buffer.appendLineSeparator();
                buffer.appendLineSeparator();
            }
            if ((import_lines_written = importCollector.writeImports(buffer)) > 0) {
                buffer.appendLineSeparator();
                total_offset_lines += import_lines_written + 1;
            }
            total_offset_lines = buffer.countLines();
            buffer.append(classBuffer);
            if (DecompilerContext.getOption("bsm")) {
                BytecodeSourceMapper mapper = DecompilerContext.getBytecodeSourceMapper();
                mapper.addTotalOffset(total_offset_lines);
                if (DecompilerContext.getOption("__dump_original_lines__")) {
                    buffer.dumpOriginalLineNumbers(mapper.getOriginalLinesMapping());
                }
                if (DecompilerContext.getOption("__unit_test_mode__")) {
                    buffer.appendLineSeparator();
                    mapper.dumpMapping(buffer, true);
                }
            }
        }
        finally {
            ClassesProcessor.destroyWrappers(root);
            DecompilerContext.getLogger().endReadingClass();
        }
    }

    private static void initWrappers(ClassNode node) throws IOException {
        if (node.type == 8) {
            return;
        }
        ClassWrapper wrapper = new ClassWrapper(node.classStruct);
        wrapper.init();
        node.wrapper = wrapper;
        for (ClassNode nd : node.nested) {
            ClassesProcessor.initWrappers(nd);
        }
    }

    private static void addClassnameToImport(ClassNode node, ImportCollector imp) {
        if (node.simpleName != null && node.simpleName.length() > 0) {
            imp.getShortName(node.type == 0 ? node.classStruct.qualifiedName : node.simpleName, false);
        }
        for (ClassNode nd : node.nested) {
            ClassesProcessor.addClassnameToImport(nd, imp);
        }
    }

    private static void destroyWrappers(ClassNode node) {
        node.wrapper = null;
        node.classStruct.releaseResources();
        for (ClassNode nd : node.nested) {
            ClassesProcessor.destroyWrappers(nd);
        }
    }

    public Map<String, ClassNode> getMapRootClasses() {
        return this.mapRootClasses;
    }

    public static class ClassNode {
        public static final int CLASS_ROOT = 0;
        public static final int CLASS_MEMBER = 1;
        public static final int CLASS_ANONYMOUS = 2;
        public static final int CLASS_LOCAL = 4;
        public static final int CLASS_LAMBDA = 8;
        public int type;
        public int access;
        public String simpleName;
        public final StructClass classStruct;
        private ClassWrapper wrapper;
        public String enclosingMethod;
        public InvocationExprent superInvocation;
        public final Map<String, VarVersionPair> mapFieldsToVars = new HashMap<String, VarVersionPair>();
        public VarType anonymousClassType;
        public final List<ClassNode> nested = new ArrayList<ClassNode>();
        public final Set<String> enclosingClasses = new HashSet<String>();
        public ClassNode parent;
        public LambdaInformation lambdaInformation;
        public boolean namelessConstructorStub = false;

        public ClassNode(String content_class_name, String content_method_name, String content_method_descriptor, int content_method_invocation_type, String lambda_class_name, String lambda_method_name, String lambda_method_descriptor, StructClass classStruct) {
            boolean is_method_reference;
            this.type = 8;
            this.classStruct = classStruct;
            this.lambdaInformation = new LambdaInformation();
            this.lambdaInformation.class_name = lambda_class_name;
            this.lambdaInformation.method_name = lambda_method_name;
            this.lambdaInformation.method_descriptor = lambda_method_descriptor;
            this.lambdaInformation.content_class_name = content_class_name;
            this.lambdaInformation.content_method_name = content_method_name;
            this.lambdaInformation.content_method_descriptor = content_method_descriptor;
            this.lambdaInformation.content_method_invocation_type = content_method_invocation_type;
            this.lambdaInformation.content_method_key = InterpreterUtil.makeUniqueKey(this.lambdaInformation.content_method_name, this.lambdaInformation.content_method_descriptor);
            this.anonymousClassType = new VarType(lambda_class_name, true);
            boolean bl = is_method_reference = content_class_name != classStruct.qualifiedName;
            if (!is_method_reference) {
                StructMethod mt = classStruct.getMethod(content_method_name, content_method_descriptor);
                is_method_reference = !mt.isSynthetic();
            }
            this.lambdaInformation.is_method_reference = is_method_reference;
            this.lambdaInformation.is_content_method_static = this.lambdaInformation.content_method_invocation_type == 6;
        }

        public ClassNode(int type, StructClass classStruct) {
            this.type = type;
            this.classStruct = classStruct;
            this.simpleName = classStruct.qualifiedName.substring(classStruct.qualifiedName.lastIndexOf(47) + 1);
        }

        public ClassNode getClassNode(String qualifiedName) {
            for (ClassNode node : this.nested) {
                if (!qualifiedName.equals(node.classStruct.qualifiedName)) continue;
                return node;
            }
            return null;
        }

        public ClassWrapper getWrapper() {
            ClassNode node = this;
            while (node.type == 8) {
                node = node.parent;
            }
            return node.wrapper;
        }

        public static class LambdaInformation {
            public String class_name;
            public String method_name;
            public String method_descriptor;
            public String content_class_name;
            public String content_method_name;
            public String content_method_descriptor;
            public int content_method_invocation_type;
            public String content_method_key;
            public boolean is_method_reference;
            public boolean is_content_method_static;
        }
    }
}

