/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

public class ValidationResult {
    public static final ValidationResult SUCCESS = new ValidationResult(Level.SUCCESS, null);
    private final Level level;
    private final String message;
    private final boolean promptDefault;

    public ValidationResult(Level level, String message, boolean promptDefault) {
        this.level = level;
        this.message = message;
        this.promptDefault = promptDefault;
    }

    public ValidationResult(Level level, String message) {
        this.level = level;
        this.message = message;
        this.promptDefault = false;
    }

    public ValidationResult() {
        this.level = null;
        this.message = null;
        this.promptDefault = false;
    }

    public boolean isSuccess() {
        return !Level.ERROR.equals((Object)this.level);
    }

    public boolean getPromptDefault() {
        return this.promptDefault;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getMessage();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (this.level != other.level) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public static enum Level {
        ERROR,
        PROMPT_TO_CONTINUE,
        WARNING,
        SUCCESS;

    }
}

