/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Latency
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###,###.##");
    private int maxTrackedLatencyMillis;
    private int min;
    private int max;
    private float avg;
    private int totalOps;
    private int percent95;
    private int percent99;
    private int opsOverflow;
    private int totalRequests;

    public Latency(int maxTrackedLatencyMillis) {
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
    }

    public Latency(int maxTrackedLatencyMillis, int minMillis, int maxMillis, float avg, int totalOps, int totalRequests, int percent95, int percent99, int requestsOverflow) {
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
        this.min = minMillis;
        this.max = maxMillis;
        this.avg = avg;
        this.totalOps = totalOps;
        this.totalRequests = totalRequests;
        this.percent95 = percent95;
        this.percent99 = percent99;
        this.opsOverflow = requestsOverflow;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.totalRequests == 0) {
            this.totalRequests = this.totalOps;
        }
    }

    public Latency clone() {
        try {
            return (Latency)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        if (this.totalOps == 0) {
            return "No operations";
        }
        return "maxTrackedLatencyMillis=" + FORMAT.format(this.maxTrackedLatencyMillis) + " totalOps=" + FORMAT.format(this.totalOps) + " totalReq=" + FORMAT.format(this.totalRequests) + " reqOverflow=" + FORMAT.format(this.opsOverflow) + " min=" + FORMAT.format(this.min) + " max=" + FORMAT.format(this.max) + " avg=" + FORMAT.format(this.avg) + " 95%=" + FORMAT.format(this.percent95) + " 99%=" + FORMAT.format(this.percent99);
    }

    public int getTotalOps() {
        return this.totalOps;
    }

    public int getTotalRequests() {
        return this.totalRequests;
    }

    public int getRequestsOverflow() {
        return this.opsOverflow;
    }

    public int getMaxTrackedLatencyMillis() {
        return this.maxTrackedLatencyMillis;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public float getAvg() {
        return this.avg;
    }

    public int get95thPercent() {
        return this.percent95;
    }

    public int get99thPercent() {
        return this.percent99;
    }

    public void rollup(Latency other) {
        if (other == null || other.totalOps == 0 || other.totalRequests == 0) {
            throw new IllegalStateException("Can't rollup a Latency that doesn't have any data");
        }
        if (this.maxTrackedLatencyMillis != other.maxTrackedLatencyMillis) {
            throw new IllegalStateException("Can't rollup a Latency whose maxTrackedLatencyMillis is different");
        }
        if (this.min > other.min) {
            this.min = other.min;
        }
        if (this.max < other.max) {
            this.max = other.max;
        }
        this.avg = ((float)this.totalRequests * this.avg + (float)other.totalRequests * other.avg) / (float)(this.totalRequests + other.totalRequests);
        this.percent95 = 0;
        this.percent99 = 0;
        this.totalOps += other.totalOps;
        this.totalRequests += other.totalRequests;
        this.opsOverflow += other.opsOverflow;
    }
}

