/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.FileWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.Task;
import org.jboss.windup.util.threading.WindupChildThread;

public class ExecutionStatistics {
    private static final Logger LOG = Logging.get(ExecutionStatistics.class);
    private static final Map<Thread, ExecutionStatistics> stats = new ConcurrentHashMap<Thread, ExecutionStatistics>();
    private final Map<String, TimingData> executionInfo = new HashMap<String, TimingData>();

    private ExecutionStatistics() {
    }

    public static synchronized ExecutionStatistics get() {
        Thread currentThread = Thread.currentThread();
        if (stats.get(currentThread) == null) {
            stats.put(currentThread, new ExecutionStatistics());
        }
        return stats.get(currentThread);
    }

    public Map<String, TimingData> getExecutionInfo() {
        return this.executionInfo;
    }

    public void merge() {
        Thread currentThread = Thread.currentThread();
        if (!stats.get(currentThread).equals(this) || currentThread instanceof WindupChildThread) {
            throw new IllegalArgumentException("Trying to merge executionstatistics from a different thread that is not registered as main thread of application run");
        }
        for (Thread thread : stats.keySet()) {
            if (!(thread instanceof WindupChildThread) || !((WindupChildThread)thread).getParentThread().equals(currentThread)) continue;
            this.merge(stats.get(thread));
        }
    }

    private void merge(ExecutionStatistics otherStatistics) {
        for (String s : otherStatistics.executionInfo.keySet()) {
            TimingData thisStats = this.executionInfo.get(s);
            TimingData otherStats = otherStatistics.executionInfo.get(s);
            if (thisStats == null) {
                this.executionInfo.put(s, otherStats);
                continue;
            }
            thisStats.merge(otherStats);
        }
    }

    public void reset() {
        stats.remove(Thread.currentThread());
        this.executionInfo.clear();
    }

    public void serializeTimingData(Path outputPath) {
        this.merge();
        try (FileWriter fw = new FileWriter(outputPath.toFile());){
            fw.write("Type~Number Of Executions~Total Milliseconds~Milliseconds per execution\n");
            for (Map.Entry<String, TimingData> timing : this.executionInfo.entrySet()) {
                TimingData data = timing.getValue();
                long totalMillis = data.totalNanos / 1000000L;
                double millisPerExecution = (double)totalMillis / (double)data.numberOfExecutions;
                fw.write(timing.getKey() + "~" + data.numberOfExecutions + "~" + totalMillis + "~" + millisPerExecution);
                fw.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T performBenchmarked(String key, Task<T> operation) {
        ExecutionStatistics instance = ExecutionStatistics.get();
        instance.begin(key);
        try {
            T t = operation.execute();
            return t;
        }
        finally {
            instance.end(key);
        }
    }

    public void begin(String key) {
        if (key == null) {
            return;
        }
        TimingData data = this.executionInfo.get(key);
        if (data == null) {
            data = new TimingData(key);
            this.executionInfo.put(key, data);
        }
        data.begin();
    }

    public void end(String key) {
        if (key == null) {
            return;
        }
        TimingData data = this.executionInfo.get(key);
        if (data == null) {
            LOG.info("Called end with key: " + key + " without ever calling begin");
            return;
        }
        data.end();
    }

    public class TimingData {
        private final String key;
        private long startTime;
        private long numberOfExecutions;
        private long totalNanos;

        public TimingData(String key) {
            this.key = key;
        }

        public void begin() {
            this.startTime = System.nanoTime();
        }

        public void end() {
            if (this.startTime == 0L) {
                LOG.info("Called end with key: " + this.key + " without ever calling begin");
                return;
            }
            this.totalNanos += System.nanoTime() - this.startTime;
            this.startTime = 0L;
            ++this.numberOfExecutions;
        }

        public void merge(TimingData other) {
            this.numberOfExecutions += other.numberOfExecutions;
            this.totalNanos = other.totalNanos;
        }

        public long getTotal() {
            return this.totalNanos;
        }
    }
}

