/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.NullWindupProgressMonitor;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.util.PathUtil;

public class WindupConfiguration {
    private static final String DEFAULT_USER_RULES_DIRECTORIES_OPTION = "defaultUserRulesDirectories";
    private static final String DEFAULT_USER_IGNORE_DIRECTORIES_OPTION = "defaultUserIgnorePaths";
    private Predicate<RuleProvider> ruleProviderFilter;
    private WindupProgressMonitor progressMonitor = new NullWindupProgressMonitor();
    private final Map<String, Object> configurationOptions = new HashMap<String, Object>();
    private boolean alwaysHaltOnException;
    private GraphContext context;

    public void useDefaultDirectories() throws IOException {
        Path windupHomeIgnoreDir;
        Path windupHomeRulesDir;
        Path userIgnoreDir;
        Path userRulesDir = PathUtil.getUserRulesDir();
        if (userRulesDir != null && !Files.isDirectory(userRulesDir, new LinkOption[0])) {
            Files.createDirectories(userRulesDir, new FileAttribute[0]);
        }
        if (userRulesDir != null) {
            this.addDefaultUserRulesDirectory(userRulesDir);
        }
        if ((userIgnoreDir = PathUtil.getUserIgnoreDir()) != null && !Files.isDirectory(userIgnoreDir, new LinkOption[0])) {
            Files.createDirectories(userIgnoreDir, new FileAttribute[0]);
        }
        if (userIgnoreDir != null) {
            this.addDefaultUserIgnorePath(userIgnoreDir);
        }
        if ((windupHomeRulesDir = PathUtil.getWindupRulesDir()) != null && !Files.isDirectory(windupHomeRulesDir, new LinkOption[0])) {
            Files.createDirectories(windupHomeRulesDir, new FileAttribute[0]);
        }
        if (windupHomeRulesDir != null) {
            this.addDefaultUserRulesDirectory(windupHomeRulesDir);
        }
        if ((windupHomeIgnoreDir = PathUtil.getWindupIgnoreDir()) != null && !Files.isDirectory(windupHomeIgnoreDir, new LinkOption[0])) {
            Files.createDirectories(windupHomeIgnoreDir, new FileAttribute[0]);
        }
        if (windupHomeIgnoreDir != null) {
            this.addDefaultUserIgnorePath(windupHomeIgnoreDir);
        }
    }

    public WindupConfiguration setOptionValue(String name, Object value) {
        this.configurationOptions.put(name, value);
        return this;
    }

    public boolean isAlwaysHaltOnException() {
        return this.alwaysHaltOnException;
    }

    public void setAlwaysHaltOnException(boolean alwaysHaltOnException) {
        this.alwaysHaltOnException = alwaysHaltOnException;
    }

    public <T> T getOptionValue(String name) {
        return (T)this.configurationOptions.get(name);
    }

    public Map<String, Object> getOptionMap() {
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public static Iterable<ConfigurationOption> getWindupConfigurationOptions() {
        return WindupConfiguration.getWindupConfigurationOptions(FurnaceHolder.getFurnace());
    }

    public static Iterable<ConfigurationOption> getWindupConfigurationOptions(Furnace furnace) {
        ArrayList<ConfigurationOption> results = new ArrayList<ConfigurationOption>();
        for (ConfigurationOption option : furnace.getAddonRegistry(new AddonRepository[0]).getServices(ConfigurationOption.class)) {
            results.add(option);
        }
        Collections.sort(results, new Comparator<ConfigurationOption>(){

            @Override
            public int compare(ConfigurationOption o1, ConfigurationOption o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return results;
    }

    public static Iterable<ConfigurationOption> getWindupConfigurationOptions(Addon addon) {
        IdentityHashMap<ClassLoader, Addon> classLoaderToAddon = new IdentityHashMap<ClassLoader, Addon>();
        for (Addon loadedAddon : FurnaceHolder.getAddonRegistry().getAddons()) {
            classLoaderToAddon.put(loadedAddon.getClassLoader(), loadedAddon);
        }
        ArrayList<ConfigurationOption> results = new ArrayList<ConfigurationOption>();
        Imported options = FurnaceHolder.getAddonRegistry().getServices(ConfigurationOption.class);
        for (ConfigurationOption option : options) {
            ClassLoader optionClassLoader = option.getClass().getClassLoader();
            Addon optionAddon = (Addon)classLoaderToAddon.get(optionClassLoader);
            if (!optionAddon.equals(addon)) continue;
            results.add(option);
        }
        return results;
    }

    public WindupConfiguration addInputPath(Path inputPath) {
        LinkedHashSet<Path> inputPaths = (LinkedHashSet<Path>)this.getOptionValue("input");
        if (inputPaths == null) {
            inputPaths = new LinkedHashSet<Path>();
            this.setOptionValue("input", inputPaths);
        }
        inputPaths.add(inputPath);
        return this;
    }

    public Collection<Path> getInputPaths() {
        Collection inputPaths = (Collection)this.getOptionValue("input");
        return inputPaths;
    }

    public Path getOutputDirectory() {
        File file = (File)this.getOptionValue("output");
        return file == null ? null : file.toPath();
    }

    public WindupConfiguration setOutputDirectory(Path outputDirectory) {
        this.setOptionValue("output", outputDirectory.toFile());
        return this;
    }

    public Iterable<Path> getAllUserRulesDirectories() {
        HashSet<Path> results = new HashSet<Path>();
        results.addAll(this.getDefaultUserRulesDirectories());
        File userSpecifiedFile = (File)this.getOptionValue("userRulesDirectory");
        if (userSpecifiedFile != null) {
            results.add(userSpecifiedFile.toPath());
        }
        return results;
    }

    public Iterable<Path> getAllIgnoreDirectories() {
        HashSet<Path> results = new HashSet<Path>();
        results.addAll(this.getDefaultUserIgnoreDirectories());
        File userSpecifiedFile = (File)this.getOptionValue("userIgnorePath");
        if (userSpecifiedFile != null) {
            results.add(userSpecifiedFile.toPath());
        }
        return results;
    }

    public List<Path> getDefaultUserRulesDirectories() {
        List paths = (List)this.getOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION);
        if (paths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(paths);
    }

    public List<Path> getDefaultUserIgnoreDirectories() {
        List paths = (List)this.getOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION);
        if (paths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(paths);
    }

    public WindupConfiguration addDefaultUserRulesDirectory(Path path) {
        File userSpecifiedRulePath;
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION);
        if (paths == null) {
            paths = new ArrayList<Path>();
            this.setOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION, paths);
        }
        if ((userSpecifiedRulePath = (File)this.getOptionValue("userRulesDirectory")) != null && userSpecifiedRulePath.toPath().equals(path)) {
            return this;
        }
        for (Path existingPath : paths) {
            if (!existingPath.equals(path)) continue;
            return this;
        }
        paths.add(path);
        return this;
    }

    public WindupConfiguration addDefaultUserIgnorePath(Path path) {
        File userSpecifiedIgnorePath;
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION);
        if (paths == null) {
            paths = new ArrayList<Path>();
            this.setOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION, paths);
        }
        if ((userSpecifiedIgnorePath = (File)this.getOptionValue("userIgnorePath")) != null && userSpecifiedIgnorePath.toPath().equals(path)) {
            return this;
        }
        for (Path existingPath : paths) {
            if (!existingPath.equals(path)) continue;
            return this;
        }
        paths.add(path);
        return this;
    }

    public Predicate<RuleProvider> getRuleProviderFilter() {
        return this.ruleProviderFilter;
    }

    public WindupConfiguration setRuleProviderFilter(Predicate<RuleProvider> ruleProviderFilter) {
        this.ruleProviderFilter = ruleProviderFilter;
        return this;
    }

    public WindupProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public WindupConfiguration setProgressMonitor(WindupProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }

    public WindupConfiguration setGraphContext(GraphContext context) {
        this.context = context;
        return this;
    }

    public GraphContext getGraphContext() {
        return this.context;
    }

    public WindupConfiguration setOffline(boolean offline) {
        this.setOptionValue("offline", offline);
        return this;
    }

    public boolean isOffline() {
        Boolean offline = (Boolean)this.getOptionValue("offline");
        return offline == null ? false : offline;
    }

    public WindupConfiguration setExportingCSV(boolean export) {
        this.setOptionValue("exportCSV", export);
        return this;
    }

    public boolean isExportingCSV() {
        Boolean export = (Boolean)this.getOptionValue("exportCSV");
        return export == null ? false : export;
    }
}

