/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemFileSummary;

public class ProblemSummary {
    private final String ruleID;
    private final String issueName;
    private int numberFound;
    private final int effortPerIncident;
    private final Map<FileModel, ProblemFileSummary> files = new LinkedHashMap<FileModel, ProblemFileSummary>();

    public ProblemSummary(String ruleID, String issueName, int numberFound, int effortPerIncident) {
        this.ruleID = ruleID;
        this.issueName = issueName;
        this.numberFound = numberFound;
        this.effortPerIncident = effortPerIncident;
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public int getNumberFound() {
        return this.numberFound;
    }

    void setNumberFound(int numberFound) {
        this.numberFound = numberFound;
    }

    public int getEffortPerIncident() {
        return this.effortPerIncident;
    }

    public Iterable<ProblemFileSummary> getFiles() {
        return this.files.values();
    }

    public void addFile(FileModel fileModel) {
        if (this.files.containsKey(fileModel)) {
            this.files.get(fileModel).addOccurence();
        } else {
            this.files.put(fileModel, new ProblemFileSummary(fileModel, 1));
        }
    }
}

