/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.dot;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.reporting.renderer.GraphWriter;
import org.jboss.windup.reporting.renderer.dot.DotConstants;

public class DotWriter
implements GraphWriter {
    private final Graph graph;
    private String graphName = "G";
    private String vertexLabelProperty = "label";
    private DotConstants.DotGraphType graphType = DotConstants.DotGraphType.DIGRAPH;
    private String fontSize = "12pt";
    private String edgeLabel = "";

    public DotWriter(Graph graph) {
        this.graph = graph;
    }

    public DotWriter(Graph graph, String graphName, String vertexLabelProperty, String edgeLabel, DotConstants.DotGraphType graphType, String fontSize) {
        this.graph = graph;
        this.graphName = graphName;
        this.fontSize = fontSize;
        this.vertexLabelProperty = vertexLabelProperty;
        this.graphType = graphType;
        this.edgeLabel = edgeLabel;
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        this.writeDot(os);
    }

    private void writeDot(OutputStream os) throws IOException {
        this.writeGraphTag(os);
    }

    private void writeGraphTag(OutputStream os) throws IOException {
        String name = this.getDotSafeName(this.graphName);
        IOUtils.write((String)(this.graphType.getName() + " " + name + "{" + "\n"), (OutputStream)os);
        this.writeGraphNodes(os);
        this.writeGraphEdges(os);
        IOUtils.write((String)"}", (OutputStream)os);
    }

    private void writeGraphEdges(OutputStream os) throws IOException {
        for (Edge edge : this.graph.getEdges()) {
            String label = this.edgeLabel;
            String source = "" + edge.getVertex(Direction.OUT).getId().toString();
            String target = "" + edge.getVertex(Direction.IN).getId().toString();
            this.writeGraphEdge(label, source, target, os);
        }
    }

    private void writeGraphEdge(String label, String source, String target, OutputStream os) throws IOException {
        String startTag = this.getDotSafeName(source) + this.graphType.getEdge() + this.getDotSafeName(target);
        String endTag = ";\n";
        IOUtils.write((String)startTag, (OutputStream)os);
        if (StringUtils.isNotBlank((String)label)) {
            this.writeOptions(os, {"label", label}, {"fontsize", this.fontSize});
        }
        IOUtils.write((String)";\n", (OutputStream)os);
    }

    private void writeGraphNode(String id, String label, OutputStream os) throws IOException {
        String tag = " \t" + this.getDotSafeName(id) + "[label = \"" + label + "\", fontsize = \"" + this.fontSize + "\"]" + ";\n";
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNodes(OutputStream os) throws IOException {
        for (Vertex vertex : this.graph.getVertices()) {
            String id = "" + vertex.getId().toString();
            String label = (String)vertex.getProperty(this.vertexLabelProperty);
            if (StringUtils.isBlank((String)label)) {
                label = vertex.toString();
            }
            this.writeGraphNode(id, label, os);
        }
    }

    private void writeOptions(OutputStream os, String[] ... options) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] option : options) {
            String key = option[0];
            String value = option[1];
            map.put(key, value);
        }
        this.writeOptions(map, os);
    }

    private void writeOptions(Map<String, String> options, OutputStream os) throws IOException {
        if (options == null || options.isEmpty()) {
            return;
        }
        IOUtils.write((String)"[", (OutputStream)os);
        StringBuilder builder = new StringBuilder();
        for (String key : options.keySet()) {
            builder.append(key + "=\"" + options.get(key) + "\", ");
        }
        String tag = builder.toString().trim();
        tag = StringUtils.removeEnd((String)tag, (String)",");
        IOUtils.write((String)tag, (OutputStream)os);
        IOUtils.write((String)"]", (OutputStream)os);
    }

    private String getDotSafeName(String inName) {
        String name = null;
        name = StringUtils.isAlphanumeric((String)inName) ? inName : "\"" + inName + "\"";
        return name;
    }
}

