/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateMigrationIssuesReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_PATH = "/reports/templates/migration-issues.ftl";

    public CreateMigrationIssuesReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateMigrationIssuesReportRuleProvider.class).setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new CreateMigrationIssueReportOperation());
    }

    private void createMigrationIssuesReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel report = applicationReportService.create();
        report.setReportPriority(110);
        report.setReportIconClass("glyphicon glyphicon-warning-sign");
        report.setReportName("Migration Issues");
        report.setTemplatePath(TEMPLATE_PATH);
        report.setTemplateType(TemplateType.FREEMARKER);
        report.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        ReportService reportService = new ReportService(context);
        if (projectModel == null) {
            reportService.setUniqueFilename((ReportModel)report, "main_migration_issues", "html");
        } else {
            report.setProjectModel(projectModel);
            reportService.setUniqueFilename((ReportModel)report, "migration_issues", "html");
        }
    }

    private class CreateMigrationIssueReportOperation
    extends GraphOperation {
        private CreateMigrationIssueReportOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            CreateMigrationIssuesReportRuleProvider.this.createMigrationIssuesReport(event.getGraphContext(), null);
            for (FileModel inputPath : WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).getInputPaths()) {
                CreateMigrationIssuesReportRuleProvider.this.createMigrationIssuesReport(event.getGraphContext(), inputPath.getProjectModel());
            }
        }
    }
}

