/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.events;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventMetadata;
import javax.inject.Singleton;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.cdi.events.InboundEvent;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.container.cdi.impl.AddonProducer;
import org.jboss.forge.furnace.container.cdi.util.BeanManagerUtils;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.weld.environment.se.events.WeldContainerEvent;

@Singleton
public class CrossContainerObserverMethod {
    private ThreadLocal<Deque<InboundEvent>> stack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(@Observes @Any Object event, EventMetadata metadata, BeanManager manager) {
        block12: {
            try {
                if (event instanceof WeldContainerEvent) {
                    return;
                }
                this.initStack();
                Addon self = BeanManagerUtils.getContextualInstance(manager, AddonProducer.class).produceCurrentAddon();
                if (self != null && !(event instanceof InboundEvent)) {
                    Set qualifiers = metadata.getQualifiers();
                    if (this.isLocal(qualifiers) || this.onStack(event, qualifiers)) break block12;
                    try {
                        AddonRegistry addonRegistry = BeanManagerUtils.getContextualInstance(manager, AddonRegistry.class);
                        for (Addon addon : addonRegistry.getAddons(AddonFilters.allStarted())) {
                            EventManager remoteEventManager;
                            if (self.getId().equals((Object)addon.getId()) || (remoteEventManager = addon.getEventManager()) == null) continue;
                            remoteEventManager.fireEvent(event, qualifiers.toArray(new Annotation[qualifiers.size()]));
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        throw new ContainerException("Problems encountered during propagation of event [" + event + "] with qualifiers [" + qualifiers + "]", (Throwable)e);
                    }
                }
                if (!(event instanceof InboundEvent)) break block12;
                try {
                    this.push((InboundEvent)event);
                    manager.fireEvent(((InboundEvent)event).getEvent(), ((InboundEvent)event).getQualifiers());
                }
                finally {
                    this.pop((InboundEvent)event);
                }
            }
            finally {
                this.cleanupStack();
            }
        }
    }

    private boolean isLocal(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (!(annotation instanceof Local)) continue;
            return true;
        }
        return false;
    }

    private boolean onStack(Object event, Set<Annotation> qualifiers) {
        InboundEvent peek = this.peek();
        return peek != null && peek.equals(new InboundEvent(event, qualifiers.toArray(new Annotation[qualifiers.size()])));
    }

    private void cleanupStack() {
        if (this.stack != null && this.stack.get() != null && this.stack.get().isEmpty()) {
            this.stack.remove();
        }
    }

    private void initStack() {
        if (this.stack == null) {
            this.stack = new ThreadLocal();
        }
        if (this.stack.get() == null) {
            this.stack.set(new ArrayDeque());
        }
    }

    private InboundEvent peek() {
        return this.stack.get().peek();
    }

    private InboundEvent pop(InboundEvent event) {
        return this.stack.get().pop();
    }

    private void push(InboundEvent event) {
        this.stack.get().push(event);
    }
}

