/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiReport
extends AbstractReport {
    private static final String NAME = "OSGi";
    private static final String DIRECTORY = "osgi";

    public OSGiReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void generate(String outputDirectory) {
        super.generate(outputDirectory);
        try {
            for (Archive archive : this.archives) {
                List<String> osgiInformation = this.getOSGIInfo(archive);
                File archiveOutput = this.writeArchiveOSGIHtml(archive, osgiInformation);
                this.writeArchiveOSGIManifest(archive, osgiInformation, archiveOutput);
            }
        }
        catch (Exception e) {
            System.err.println("OSGiReport: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void writeArchiveOSGIManifest(Archive archive, List<String> osgiInformation, File archiveOutput) throws IOException {
        FileWriter mfw = new FileWriter(archiveOutput.getAbsolutePath() + File.separator + "MANIFEST.MF");
        BufferedWriter mbw = new BufferedWriter(mfw, 8192);
        if (archive.getManifest() != null) {
            for (String s : archive.getManifest()) {
                mbw.write(s);
                mbw.write(Dump.newLine());
            }
        }
        if (!archive.isOSGi() && osgiInformation != null && osgiInformation.size() > 0) {
            mbw.write(Dump.newLine());
            mbw.write("### OSGi information" + Dump.newLine());
            for (String anOsgiInformation : osgiInformation) {
                if (anOsgiInformation.length() <= 69) {
                    mbw.write(anOsgiInformation);
                    mbw.write(Dump.newLine());
                    continue;
                }
                int count = 0;
                for (int i = 0; i < anOsgiInformation.length(); ++i) {
                    char c = anOsgiInformation.charAt(i);
                    if (count <= 69) {
                        mbw.write(c);
                        ++count;
                        continue;
                    }
                    mbw.write(Dump.newLine());
                    mbw.write(32);
                    mbw.write(c);
                    count = 2;
                }
                mbw.write(Dump.newLine());
            }
        }
        mbw.flush();
        mbw.close();
    }

    private File writeArchiveOSGIHtml(Archive archive, List<String> osgiInformation) throws IOException {
        File archiveOutput = new File(this.getOutputDirectory(), archive.getName());
        archiveOutput.mkdirs();
        FileWriter rfw = new FileWriter(archiveOutput.getAbsolutePath() + File.separator + "index.html");
        BufferedWriter rbw = new BufferedWriter(rfw, 8192);
        rbw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.newLine());
        rbw.write("<html>" + Dump.newLine());
        rbw.write("<head>" + Dump.newLine());
        rbw.write("  <title>JBoss Tattletale 1.2.0.Beta2: OSGi - " + archive.getName() + "</title>" + Dump.newLine());
        rbw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.newLine());
        rbw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"../../style.css\">" + Dump.newLine());
        rbw.write("</head>" + Dump.newLine());
        rbw.write("<body>" + Dump.newLine());
        rbw.write(Dump.newLine());
        rbw.write("<h1>OSGi - " + archive.getName() + "</h1>" + Dump.newLine());
        rbw.write("<a href=\"../index.html\">Back</a>" + Dump.newLine());
        rbw.write("<p>" + Dump.newLine());
        rbw.write("<table>" + Dump.newLine());
        rbw.write("  <tr>" + Dump.newLine());
        rbw.write("     <th>Field</th>" + Dump.newLine());
        rbw.write("     <th>Value</th>" + Dump.newLine());
        rbw.write("  </tr>" + Dump.newLine());
        rbw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        rbw.write("     <td>OSGi</td>" + Dump.newLine());
        if (archive.isOSGi()) {
            rbw.write("     <td style=\"color: green;\">Yes</td>" + Dump.newLine());
        } else {
            rbw.write("     <td style=\"color: red;\">No</td>" + Dump.newLine());
        }
        rbw.write("  </tr>" + Dump.newLine());
        rbw.write("  <tr class=\"roweven\">" + Dump.newLine());
        rbw.write("     <td>Manifest</td>" + Dump.newLine());
        rbw.write("     <td><pre>");
        if (archive.getManifest() != null) {
            for (String s : archive.getManifest()) {
                rbw.write(s);
                rbw.write("<br>");
            }
        }
        rbw.write("</pre></td>" + Dump.newLine());
        rbw.write("  </tr>" + Dump.newLine());
        if (!archive.isOSGi()) {
            rbw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            rbw.write("     <td>OSGi Manifest</td>" + Dump.newLine());
            rbw.write("     <td><pre>");
            if (osgiInformation != null && osgiInformation.size() > 0) {
                for (String anOsgiInformation : osgiInformation) {
                    rbw.write(anOsgiInformation);
                    rbw.write("<br>");
                }
            }
            rbw.write("</pre></td>" + Dump.newLine());
            rbw.write("  </tr>" + Dump.newLine());
        }
        rbw.write("</table>" + Dump.newLine());
        rbw.write(Dump.newLine());
        rbw.write("<p>" + Dump.newLine());
        rbw.write("<hr>" + Dump.newLine());
        rbw.write("Generated by: <a href=\"http://www.jboss.org/tattletale\">JBoss Tattletale 1.2.0.Beta2</a>" + Dump.newLine());
        rbw.write(Dump.newLine());
        rbw.write("</body>" + Dump.newLine());
        rbw.write("</html>" + Dump.newLine());
        rbw.flush();
        rbw.close();
        return archiveOutput;
    }

    private List<String> getOSGIInfo(Archive archive) {
        ArrayList<String> osgiInformation = null;
        if (!archive.isOSGi()) {
            String bundleSymbolicName;
            osgiInformation = new ArrayList<String>();
            TreeMap<String, Integer> exportPackages = new TreeMap<String, Integer>();
            for (String provide : archive.getProvides().keySet()) {
                if (provide.lastIndexOf(".") == -1) continue;
                String packageName = provide.substring(0, provide.lastIndexOf("."));
                Integer number = (Integer)exportPackages.get(packageName);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exportPackages.put(packageName, number);
            }
            TreeMap<String, String> importPackages = new TreeMap<String, String>();
            for (String require : archive.getRequires()) {
                String packageName;
                if (require.lastIndexOf(".") == -1 || importPackages.get(packageName = require.substring(0, require.lastIndexOf("."))) != null) continue;
                String version = null;
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (!a.doesProvide(require)) continue;
                    version = a.getLocations().first().getVersion();
                    if (version == null) {
                        version = "0.0.0";
                    }
                    found = true;
                }
                importPackages.put(packageName, version);
            }
            osgiInformation.add("Bundle-ManifestVersion: 2");
            if (exportPackages.size() > 0) {
                String bsn = null;
                Integer bsnv = null;
                for (Map.Entry entry : exportPackages.entrySet()) {
                    String pkg = (String)entry.getKey();
                    Integer v = (Integer)entry.getValue();
                    if (bsn == null) {
                        bsn = pkg;
                        bsnv = v;
                        continue;
                    }
                    if (v <= bsnv) continue;
                    bsn = pkg;
                    bsnv = v;
                }
                bundleSymbolicName = bsn;
            } else {
                bundleSymbolicName = "UNKNOWN";
            }
            osgiInformation.add("Bundle-SymbolicName: " + bundleSymbolicName);
            String bundleDescription = archive.getName().substring(0, archive.getName().lastIndexOf("."));
            osgiInformation.add("Bundle-Description: " + bundleDescription);
            String bName = archive.getName().substring(0, archive.getName().lastIndexOf("."));
            StringBuffer bundleName = new StringBuffer();
            for (int i = 0; i < bName.length(); ++i) {
                char c = bName.charAt(i);
                if (c == '\n' || c == '\r' || c == ' ') continue;
                bundleName = bundleName.append(c);
            }
            osgiInformation.add("Bundle-Name: " + bundleName.toString());
            Location location = archive.getLocations().first();
            String bundleVersion = this.getOSGiVersion(location.getVersion());
            osgiInformation.add("Bundle-Version: " + bundleVersion);
            StringBuffer exportPackage = new StringBuffer();
            Iterator eit = exportPackages.keySet().iterator();
            while (eit.hasNext()) {
                String ep = (String)eit.next();
                exportPackage = exportPackage.append(ep);
                SortedSet epd = (SortedSet)archive.getPackageDependencies().get(ep);
                if (epd != null && epd.size() > 0) {
                    exportPackage = exportPackage.append(";uses:=\"");
                    Iterator epdi = epd.iterator();
                    while (epdi.hasNext()) {
                        exportPackage = exportPackage.append((String)epdi.next());
                        if (!epdi.hasNext()) continue;
                        exportPackage = exportPackage.append(",");
                    }
                    exportPackage = exportPackage.append("\"");
                }
                if (!eit.hasNext()) continue;
                exportPackage = exportPackage.append(",");
            }
            osgiInformation.add("Export-Package: " + exportPackage.toString());
            StringBuffer importPackage = new StringBuffer();
            Iterator iit = importPackages.entrySet().iterator();
            while (iit.hasNext()) {
                Map.Entry entry = iit.next();
                String pkg = (String)entry.getKey();
                String v = (String)entry.getValue();
                importPackage = importPackage.append(pkg);
                if (v != null) {
                    importPackage = importPackage.append(";version=\"");
                    importPackage = importPackage.append(this.getOSGiVersion(v));
                    importPackage = importPackage.append("\"");
                }
                if (!iit.hasNext()) continue;
                importPackage = importPackage.append(",");
            }
            osgiInformation.add("Import-Package: " + importPackage.toString());
        }
        return osgiInformation;
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>OSGi</th>" + Dump.newLine());
        bw.write("     <th>Report</th>" + Dump.newLine());
        bw.write("     <th>Manifest</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        int osgiReady = 0;
        int osgiNotReady = 0;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            if (archive.isOSGi()) {
                bw.write("     <td style=\"color: green;\">Yes</td>" + Dump.newLine());
                ++osgiReady;
            } else {
                ++osgiNotReady;
                if (!this.isFiltered(archiveName)) {
                    this.status = 2;
                    bw.write("     <td style=\"color: red;\">No</td>" + Dump.newLine());
                } else {
                    bw.write("     <td style=\"color: red; text-decoration: line-through;\">No</td>" + Dump.newLine());
                }
            }
            bw.write("     <td><a href=\"" + archiveName + "/index.html\">Report</a></td>" + Dump.newLine());
            bw.write("     <td><a href=\"" + archiveName + "/MANIFEST.MF\">Manifest</a></td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<p>" + Dump.newLine());
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("     <th>Archives</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Ready</td>" + Dump.newLine());
        bw.write("     <td style=\"color: green;\">" + osgiReady + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Not ready</td>" + Dump.newLine());
        bw.write("     <td style=\"color: red;\">" + osgiNotReady + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>OSGi</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    private String getOSGiVersion(String version) {
        if (version == null) {
            return "0.0.0";
        }
        if (!version.matches("\\d+(\\.\\d+(\\.\\d+(\\.[0-9a-zA-Z\\_\\-]+)?)?)?")) {
            return "0.0.0";
        }
        return version;
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

