/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.input;

import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;

public abstract class AbstractUIInputDecorator<VALUETYPE>
implements UIInput<VALUETYPE> {
    private UIInput<VALUETYPE> delegate;

    protected abstract UIInput<VALUETYPE> createDelegate();

    protected final UIInput<VALUETYPE> getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
            Assert.notNull(this.delegate, (String)"Delegate cannot be null");
            Assert.isTrue((this.delegate != this ? 1 : 0) != 0, (String)"Decorator cannot delegate to itself");
        }
        return this.delegate;
    }

    @Override
    public String getLabel() {
        return this.getDelegate().getLabel();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    @Override
    public Class<VALUETYPE> getValueType() {
        return this.getDelegate().getValueType();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.getDelegate().hasDefaultValue();
    }

    @Override
    public boolean hasValue() {
        return this.getDelegate().hasValue();
    }

    @Override
    public boolean isEnabled() {
        return this.getDelegate().isEnabled();
    }

    @Override
    public boolean isRequired() {
        return this.getDelegate().isRequired();
    }

    @Override
    public String getRequiredMessage() {
        return this.getDelegate().getRequiredMessage();
    }

    @Override
    public char getShortName() {
        return this.getDelegate().getShortName();
    }

    @Override
    public Set<UIValidator> getValidators() {
        return this.getDelegate().getValidators();
    }

    @Override
    public UIInput<VALUETYPE> setEnabled(boolean b) {
        this.getDelegate().setEnabled(b);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setEnabled(Callable<Boolean> callable) {
        this.getDelegate().setEnabled(callable);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setLabel(String label) {
        this.getDelegate().setLabel(label);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setDescription(String description) {
        this.getDelegate().setDescription(description);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setDescription(Callable<String> description) {
        this.getDelegate().setDescription(description);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setRequired(boolean required) {
        this.getDelegate().setRequired(required);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setRequired(Callable<Boolean> required) {
        this.getDelegate().setRequired(required);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setRequiredMessage(String message) {
        this.getDelegate().setRequiredMessage(message);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setRequiredMessage(Callable<String> message) {
        this.getDelegate().setRequiredMessage(message);
        return this;
    }

    @Override
    public Converter<String, VALUETYPE> getValueConverter() {
        return this.getDelegate().getValueConverter();
    }

    @Override
    public UIInput<VALUETYPE> setValueConverter(Converter<String, VALUETYPE> converter) {
        this.getDelegate().setValueConverter(converter);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> addValidator(UIValidator validator) {
        this.getDelegate().addValidator(validator);
        return this;
    }

    @Override
    public VALUETYPE getValue() {
        return (VALUETYPE)this.getDelegate().getValue();
    }

    @Override
    public ListenerRegistration<ValueChangeListener> addValueChangeListener(ValueChangeListener listener) {
        return this.getDelegate().addValueChangeListener(listener);
    }

    @Override
    public void validate(UIValidationContext context) {
        this.getDelegate().validate(context);
    }

    @Override
    public UIInput<VALUETYPE> setNote(String note) {
        this.getDelegate().setNote(note);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setNote(Callable<String> note) {
        this.getDelegate().setNote(note);
        return this;
    }

    @Override
    public String getNote() {
        return this.getDelegate().getNote();
    }

    public boolean install(HintsFacet facet) {
        return this.getDelegate().install(facet);
    }

    public boolean register(HintsFacet facet) {
        return this.getDelegate().register(facet);
    }

    public boolean unregister(HintsFacet facet) {
        return this.unregister(facet);
    }

    public boolean uninstall(HintsFacet facet) {
        return this.getDelegate().uninstall(facet);
    }

    public boolean hasFacet(Class<? extends HintsFacet> type) {
        return this.getDelegate().hasFacet(type);
    }

    public boolean hasAllFacets(Class<? extends HintsFacet> ... facetDependencies) {
        return this.getDelegate().hasAllFacets(facetDependencies);
    }

    public boolean hasAllFacets(Iterable<Class<? extends HintsFacet>> facetDependencies) {
        return this.getDelegate().hasAllFacets(facetDependencies);
    }

    public <F extends HintsFacet> F getFacet(Class<F> type) throws FacetNotFoundException {
        return (F)((HintsFacet)this.getDelegate().getFacet(type));
    }

    public Iterable<HintsFacet> getFacets() {
        return this.getDelegate().getFacets();
    }

    public <F extends HintsFacet> Iterable<F> getFacets(Class<F> type) {
        return this.getDelegate().getFacets(type);
    }

    public <F extends HintsFacet> boolean supports(F facet) {
        return this.getDelegate().supports(facet);
    }

    @Override
    public UIInput<VALUETYPE> setDefaultValue(VALUETYPE value) {
        this.getDelegate().setDefaultValue(value);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setDefaultValue(Callable<VALUETYPE> callback) {
        this.getDelegate().setDefaultValue(callback);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setValue(VALUETYPE value) {
        this.getDelegate().setValue(value);
        return this;
    }

    @Override
    public UICompleter<VALUETYPE> getCompleter() {
        return this.getDelegate().getCompleter();
    }

    @Override
    public UIInput<VALUETYPE> setCompleter(UICompleter<VALUETYPE> completer) {
        this.getDelegate().setCompleter(completer);
        return this;
    }

    @Override
    public UIInput<VALUETYPE> setDeprecated(boolean deprecated) {
        this.getDelegate().setDeprecated(deprecated);
        return this;
    }

    @Override
    public boolean isDeprecated() {
        return this.getDelegate().isDeprecated();
    }

    @Override
    public UIInput<VALUETYPE> setDeprecatedMessage(String message) {
        this.getDelegate().setDeprecatedMessage(message);
        return this;
    }

    @Override
    public String getDeprecatedMessage() {
        return this.getDelegate().getDeprecatedMessage();
    }
}

