/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.UnsupportedVersion;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.util.Preconditions;

public class JandexIndexBeanArchiveHandler
implements BeanArchiveHandler {
    private static final Logger logger = Logger.getLogger(JandexIndexBeanArchiveHandler.class);
    private static final String JANDEX_INDEX_NAME = "META-INF/jandex.idx";

    @Override
    public BeanArchiveBuilder handle(String path) {
        File beanArchiveFile = new File(path);
        if (!beanArchiveFile.canRead() || beanArchiveFile.isDirectory()) {
            return null;
        }
        Index index = this.getIndex(beanArchiveFile);
        if (index == null) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder().setAttribute(JandexDiscoveryStrategy.INDEX_ATTRIBUTE_NAME, index);
        this.handleArchiveByIndex(index, builder);
        return builder;
    }

    private Index getIndex(File beanArchiveFile) {
        Preconditions.checkArgumentNotNull((Object)beanArchiveFile, (String)"beanArchiveFile");
        logger.debugv("Try to get Jandex index for: {0}", (Object)beanArchiveFile);
        Index index = null;
        try (ZipFile zip = new ZipFile(beanArchiveFile);){
            ZipEntry entry = zip.getEntry(JANDEX_INDEX_NAME);
            if (entry != null) {
                index = new IndexReader(zip.getInputStream(entry)).read();
            }
        }
        catch (IllegalArgumentException e) {
            CommonLogger.LOG.warnv("Jandex index is not valid: {0}", beanArchiveFile);
        }
        catch (UnsupportedVersion e) {
            CommonLogger.LOG.warnv("Version of Jandex index is not supported: {0}", beanArchiveFile);
        }
        catch (IOException e) {
            CommonLogger.LOG.warnv("Cannot get Jandex index from: {0}", beanArchiveFile);
            CommonLogger.LOG.catchingDebug(e);
        }
        logger.debugv("Jandex index {0}found: {1}", (Object)(index == null ? "NOT " : ""), (Object)beanArchiveFile);
        return index;
    }

    private void handleArchiveByIndex(Index index, BeanArchiveBuilder builder) {
        for (ClassInfo classInfo : index.getKnownClasses()) {
            builder.addClass(classInfo.name().toString());
        }
    }
}

