/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation;

import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ProgressEstimate;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class IterationProgress
extends AbstractIterationOperation<WindupVertexFrame> {
    private static final Logger LOG = Logging.get(IterationProgress.class);
    private final String messagePrefix;
    private final int interval;
    private int totalIterations = -1;
    private boolean estimateTimeRemaining = true;
    private ProgressEstimate progressEstimate;

    private IterationProgress(String messagePrefix, int interval) {
        this.messagePrefix = messagePrefix;
        this.interval = interval;
    }

    public static IterationProgress monitoring(String messagePrefix, int interval) {
        return new IterationProgress(messagePrefix, interval);
    }

    public IterationProgress disableTimeEstimation() {
        this.estimateTimeRemaining = false;
        return this;
    }

    @Override
    public void perform(GraphRewrite event, EvaluationContext context) {
        if (this.totalIterations == -1) {
            Iterable frames = (Iterable)event.getRewriteContext().get((Object)"default");
            this.totalIterations = Iterators.asList((Iterable)frames).size();
            this.progressEstimate = new ProgressEstimate(this.totalIterations);
        }
        this.progressEstimate.addWork(1);
        if (this.progressEstimate.getWorked() % this.interval == 0) {
            long remainingTimeMillis;
            if (this.estimateTimeRemaining && (remainingTimeMillis = this.progressEstimate.getTimeRemainingInMillis()) > 1000L) {
                event.ruleEvaluationProgress(this.messagePrefix, this.progressEstimate.getWorked(), this.totalIterations, (int)remainingTimeMillis / 1000);
            }
            LOG.info(this.messagePrefix + ": " + this.progressEstimate.getWorked() + " / " + this.totalIterations);
        }
    }

    @Override
    public void perform(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
    }

    public String toString() {
        return "IterationProgress{msg=" + this.messagePrefix + ", int=" + this.interval + ", est=" + this.estimateTimeRemaining + '}';
    }
}

