/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.git.GitUtils;
import org.jboss.forge.addon.git.gitignore.resources.GitIgnoreResource;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

abstract class AbstractGitCommand
extends AbstractProjectCommand {
    private ProjectFactory projectFactory;
    private InputComponentFactory inputComponentFactory;
    private GitUtils gitUtils;
    private ResourceFactory resourceFactory;
    private FacetFactory facetFactory;

    AbstractGitCommand() {
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{"SCM / GIT"}));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    protected ProjectFactory getProjectFactory() {
        if (this.projectFactory == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.projectFactory = (ProjectFactory)addonRegistry.getServices(ProjectFactory.class).get();
        }
        return this.projectFactory;
    }

    protected GitIgnoreResource gitIgnoreResource(UIContext context) {
        GitIgnoreResource resource = (GitIgnoreResource)((DirectoryResource)this.getSelectedProject(context).getRoot().reify(DirectoryResource.class)).getChildOfType(GitIgnoreResource.class, ".gitignore");
        if (resource == null || !resource.exists()) {
            resource.createNewFile();
        }
        return resource;
    }

    protected boolean isGitIgnoreSelected(UIContext context) {
        return context.getInitialSelection().get() instanceof GitIgnoreResource;
    }

    protected InputComponentFactory getInputComponentFactory() {
        if (this.inputComponentFactory == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.inputComponentFactory = (InputComponentFactory)addonRegistry.getServices(InputComponentFactory.class).get();
        }
        return this.inputComponentFactory;
    }

    protected GitUtils getGitUtils() {
        if (this.gitUtils == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.gitUtils = (GitUtils)addonRegistry.getServices(GitUtils.class).get();
        }
        return this.gitUtils;
    }

    protected ResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.resourceFactory = (ResourceFactory)addonRegistry.getServices(ResourceFactory.class).get();
        }
        return this.resourceFactory;
    }

    protected FacetFactory getFacetFactory() {
        if (this.facetFactory == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.facetFactory = (FacetFactory)addonRegistry.getServices(FacetFactory.class).get();
        }
        return this.facetFactory;
    }
}

