/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitCheckoutCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={GitFacet.class})
public class GitCheckoutCommandImpl
extends AbstractGitCommand
implements GitCheckoutCommand {
    private UIInput<String> branchName;
    private UIInput<Boolean> create;
    private UISelectOne<CreateBranchCommand.SetupUpstreamMode> trackingMode;
    private UIInput<Boolean> force;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GIT: Checkout").description("Checkout a branch from GIT repository or create a new one");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.branchName = (UIInput)((UIInput)this.getInputComponentFactory().createInput("branchName", String.class).setLabel("Branch name")).setDefaultValue((Object)"master");
        this.create = (UIInput)((UIInput)this.getInputComponentFactory().createInput("create", Boolean.class).setLabel("Create branch")).setDefaultValue((Object)false);
        this.trackingMode = (UISelectOne)((UISelectOne)((UISelectOne)this.getInputComponentFactory().createSelectOne("trackingMode", CreateBranchCommand.SetupUpstreamMode.class).setLabel("Track")).setDescription("Remote tracking mode")).setDefaultValue((Object)CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
        this.force = (UIInput)((UIInput)this.getInputComponentFactory().createInput("forge", Boolean.class).setLabel("Force")).setDefaultValue((Object)false);
        builder.add(this.branchName).add(this.create).add(this.trackingMode).add(this.force);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Result result = null;
        if (project != null) {
            try (Git git = this.getGitUtils().git((DirectoryResource)project.getRoot().reify(DirectoryResource.class));){
                this.getGitUtils().checkout(git, (String)this.branchName.getValue(), ((Boolean)this.create.getValue()).booleanValue(), (CreateBranchCommand.SetupUpstreamMode)this.trackingMode.getValue(), ((Boolean)this.force.getValue()).booleanValue());
            }
            result = Results.success();
        } else {
            result = Results.fail((String)"This command should be executed in the context of a project");
        }
        return result;
    }
}

