/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.gitignore.GitIgnoreConfig;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreSetupCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

@FacetConstraint(value={GitFacet.class})
public class GitIgnoreSetupCommandImpl
extends AbstractGitCommand
implements GitIgnoreSetupCommand {
    private UIInput<FileResource> templateRepoDir;
    private UIInput<String> repository;
    private GitIgnoreConfig gitIgnoreConfig;
    FacetFactory facetFactory;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GITIGNORE: Setup").description("Create .gitignore files based on template files from https://github.com/github/gitignore.git.");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.templateRepoDir = (UIInput)((UIInput)((UIInput)this.getInputComponentFactory().createInput("templateRepoDir", FileResource.class).setLabel("Checkout directory")).setDescription("Where should the gitignore template repository be installed at?")).setDefaultValue(this.getDefaultCheckoutDir());
        this.repository = (UIInput)((UIInput)((UIInput)this.getInputComponentFactory().createInput("repository", String.class).setLabel("Repository")).setDescription("Do you want to provide a different repository location for gitignore templates?")).setDefaultValue((Object)this.getGitIgnoreConfig().defaultRemoteRepository());
        builder.add(this.templateRepoDir).add(this.repository);
    }

    private FileResource<?> getDefaultCheckoutDir() {
        return (FileResource)this.getResourceFactory().create((Object)this.getGitIgnoreConfig().defaultLocalRepository());
    }

    public void validate(UIValidationContext context) {
        FileResource checkoutDir = (FileResource)this.templateRepoDir.getValue();
        if (checkoutDir.exists()) {
            if (!checkoutDir.isDirectory()) {
                context.addValidationError(this.templateRepoDir, "File " + checkoutDir + " is not a directory.");
            }
            if (!checkoutDir.listResources().isEmpty()) {
                context.addValidationError(this.templateRepoDir, "Directory " + checkoutDir + " is not empty");
            }
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        FileResource checkoutDir = (FileResource)this.templateRepoDir.getValue();
        if (!checkoutDir.exists()) {
            checkoutDir.mkdirs();
        }
        this.getGitIgnoreConfig().setLocalRepository(checkoutDir.getFullyQualifiedName());
        this.getGitIgnoreConfig().setRemoteRepository((String)this.repository.getValue());
        this.getFacetFactory().install((Faceted)this.getSelectedProject((UIContextProvider)context), GitIgnoreFacet.class);
        return Results.success((String)"GITIGNORE has been installed.");
    }

    private GitIgnoreConfig getGitIgnoreConfig() {
        if (this.gitIgnoreConfig == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.gitIgnoreConfig = (GitIgnoreConfig)addonRegistry.getServices(GitIgnoreConfig.class).get();
        }
        return this.gitIgnoreConfig;
    }
}

