/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitializationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.config.CopyJavaConfigToGraphRuleProvider;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class GatherIgnoredFileNamesRuleProvider
extends IteratingRuleProvider<WindupConfigurationModel> {
    private final String IGNORE_FILE_EXTENSION = "windup-ignore.txt";
    private static final Logger log = Logger.getLogger(GatherIgnoredFileNamesRuleProvider.class.getName());

    public GatherIgnoredFileNamesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(GatherIgnoredFileNamesRuleProvider.class).setPhase(InitializationPhase.class).addExecuteAfter(CopyJavaConfigToGraphRuleProvider.class));
    }

    public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
        WindupJavaConfigurationModel javaCfg = WindupJavaConfigurationService.getJavaConfigurationModel((GraphContext)event.getGraphContext());
        final ArrayList<Path> filesUrl = new ArrayList<Path>();
        for (FileModel ignoredRegexesFileModel : payload.getUserIgnorePaths()) {
            if (ignoredRegexesFileModel.isDirectory()) {
                try {
                    Files.walkFileTree(Paths.get(ignoredRegexesFileModel.getFilePath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (file.getFileName().toString().toLowerCase().endsWith("windup-ignore.txt")) {
                                filesUrl.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e1) {
                    log.warning("IOException thrown when trying to access the ignored file regexes in " + ignoredRegexesFileModel.getFilePath());
                }
                continue;
            }
            filesUrl.add(Paths.get(ignoredRegexesFileModel.getFilePath(), new String[0]));
        }
        for (Path filePath : filesUrl) {
            this.readAndAddFileRegexes(filePath, javaCfg, event.getGraphContext());
        }
    }

    private void readAndAddFileRegexes(Path filePath, WindupJavaConfigurationModel javaCfg, GraphContext context) {
        File file = filePath.toFile();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    GraphService graphService = new GraphService(context, IgnoredFileRegexModel.class);
                    IgnoredFileRegexModel ignored = (IgnoredFileRegexModel)graphService.create();
                    ignored.setRegex(line);
                    javaCfg.addIgnoredFileRegex(ignored);
                    try {
                        Pattern.compile(line);
                    }
                    catch (PatternSyntaxException exception) {
                        ignored.setCompilationError(exception.getMessage());
                    }
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public ConditionBuilder when() {
        return Query.fromType(WindupConfigurationModel.class);
    }

    public String toStringPerform() {
        return "Gather all the information about ignored files.";
    }
}

