/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.util;

import com.github.rwitzel.streamflyer.core.AfterModification;
import com.github.rwitzel.streamflyer.internal.thirdparty.ZzzValidate;

public class ModificationFactory {
    private int minimumLengthOfLookBehind;
    private int newNumberOfChars;

    protected ModificationFactory() {
    }

    public ModificationFactory(int minimumLengthOfLookBehind, int newNumberOfChars) {
        ZzzValidate.isGreaterThanZero(newNumberOfChars, "newNumberOfChars");
        ZzzValidate.isZeroOrPositiveNumber(minimumLengthOfLookBehind, "minimumLengthOfLookBehind");
        this.minimumLengthOfLookBehind = minimumLengthOfLookBehind;
        this.newNumberOfChars = newNumberOfChars;
    }

    public AfterModification skipEntireBuffer(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.skipOrStop(characterBuffer.length() - firstModifiableCharacterInBuffer, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
    }

    public AfterModification skipOrStop(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        if (endOfStreamHit && characterBuffer.length() - firstModifiableCharacterInBuffer == 0) {
            ZzzValidate.isTrue(numberOfCharactersToSkip == 0, "numberOfCharactersToSkip must be zero");
            return this.stop(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        }
        return this.skip(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
    }

    public AfterModification skip(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        if (numberOfCharactersToSkip == 0 && (characterBuffer.length() - firstModifiableCharacterInBuffer != 0 || endOfStreamHit)) {
            String msg = String.format("Probably a programming error. Therefore, we don't fix it automatically. (%s, %s, %s, %s)", characterBuffer, firstModifiableCharacterInBuffer, characterBuffer.length(), endOfStreamHit);
            throw new IllegalStateException(msg);
        }
        int numberOfModifiableCharactersInBuffer = characterBuffer.length() - firstModifiableCharacterInBuffer;
        if (numberOfCharactersToSkip > numberOfModifiableCharactersInBuffer) {
            String msg = String.format("Probably a programming error. Therefore, we don't fix it automatically. (%s, %s, %s, %s)", characterBuffer, firstModifiableCharacterInBuffer, numberOfCharactersToSkip, characterBuffer.length());
            throw new IllegalStateException(msg);
        }
        int minimumLengthOfLookBehind_ = this.minimumLengthOfLookBehind;
        if (minimumLengthOfLookBehind_ > firstModifiableCharacterInBuffer + numberOfCharactersToSkip) {
            minimumLengthOfLookBehind_ = firstModifiableCharacterInBuffer + numberOfCharactersToSkip;
        }
        int newNumberOfChars_ = this.newNumberOfChars;
        return new AfterModification(numberOfCharactersToSkip, false, minimumLengthOfLookBehind_, newNumberOfChars_);
    }

    public AfterModification fetchMoreInput(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        int newNumberOfChars_;
        ZzzValidate.isTrue(!endOfStreamHit, "endOfStreamHit must not be false");
        int numberOfModifiableCharactersInBuffer = characterBuffer.length() - firstModifiableCharacterInBuffer;
        if (numberOfCharactersToSkip > numberOfModifiableCharactersInBuffer) {
            String msg = String.format("Probably a programming error. Therefore, we don't fix it automatically. (%s, %s, %s, %s)", characterBuffer, firstModifiableCharacterInBuffer, numberOfCharactersToSkip, characterBuffer.length());
            throw new IllegalStateException(msg);
        }
        int minimumLengthOfLookBehind_ = this.minimumLengthOfLookBehind;
        if (minimumLengthOfLookBehind_ > firstModifiableCharacterInBuffer + numberOfCharactersToSkip) {
            minimumLengthOfLookBehind_ = firstModifiableCharacterInBuffer + numberOfCharactersToSkip;
        }
        int modifiableCharsInBufferAfterSkip = numberOfModifiableCharactersInBuffer - numberOfCharactersToSkip;
        for (newNumberOfChars_ = this.newNumberOfChars; newNumberOfChars_ <= modifiableCharsInBufferAfterSkip; newNumberOfChars_ *= 2) {
        }
        if (numberOfCharactersToSkip > 0) {
            return new AfterModification(numberOfCharactersToSkip, false, minimumLengthOfLookBehind_, newNumberOfChars_);
        }
        return new AfterModification(0, true, minimumLengthOfLookBehind_, newNumberOfChars_);
    }

    public AfterModification modifyAgainImmediately(int newNumberOfChars_, int firstModifiableCharacterInBuffer) {
        return new AfterModification(0, true, firstModifiableCharacterInBuffer, newNumberOfChars_);
    }

    public AfterModification stop(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        if (characterBuffer.length() - firstModifiableCharacterInBuffer != 0 || !endOfStreamHit) {
            String msg = String.format("Probably a programming error. Therefore, we don't fix it automatically. (%s, %s, %s, %s)", characterBuffer, firstModifiableCharacterInBuffer, characterBuffer.length(), endOfStreamHit);
            throw new IllegalStateException(msg);
        }
        return new AfterModification(0, false, 0, 1);
    }

    public int getNewNumberOfChars() {
        return this.newNumberOfChars;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModificationFactory [\nminimumLengthOfLookBehind=");
        builder.append(this.minimumLengthOfLookBehind);
        builder.append(", \nnewNumberOfChars=");
        builder.append(this.newNumberOfChars);
        builder.append("]");
        return builder.toString();
    }
}

