/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util.iterators;

import com.tinkerpop.pipes.util.FastNoSuchElementException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MultiIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> iterators;
    private Iterator<T> currentIterator = null;

    public MultiIterator(Iterator<T> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public MultiIterator(List<Iterator<T>> iterators) {
        this.iterators = iterators.iterator();
        if (this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        while (true) {
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
        throw FastNoSuchElementException.instance();
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (null != this.currentIterator && this.currentIterator.hasNext()) {
                return true;
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
        return false;
    }
}

