/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class BindingAssigner
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        if (bindings.size() > 0) {
            tupleExpr.visit((QueryModelVisitor)new VarVisitor(bindings));
        }
    }

    protected static class VarVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected BindingSet bindings;

        public VarVisitor(BindingSet bindings) {
            this.bindings = bindings;
        }

        public void meet(Var var) {
            if (!var.hasValue() && this.bindings.hasBinding(var.getName())) {
                Value value = this.bindings.getValue(var.getName());
                var.setValue(value);
            }
        }
    }
}

