/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss.jbpm3;

import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.Jbpm3ProcessModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateJBossJBPMReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/jbpm.ftl";
    public static final String REPORT_DESCRIPTION = "This report contains all of the JBPM related resources that were discovered during analysis.";

    public CreateJBossJBPMReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateJBossJBPMReportRuleProvider.class, (String)"Create JBPM Report").setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(Jbpm3ProcessModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    CreateJBossJBPMReportRuleProvider.this.createJbpmReport(event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "CreateJBPM3Report";
            }
        });
    }

    private void createJbpmReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("JBPM");
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon bpm-nav-logo");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        GraphService jbpmProcessService = new GraphService(context, Jbpm3ProcessModel.class);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel processes = (WindupVertexListModel)listService.create();
        for (Jbpm3ProcessModel processModel : jbpmProcessService.findAll()) {
            processes.addItem((WindupVertexFrame)processModel);
        }
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(4);
        additionalData.put("processes", processes);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "jbpmreport_" + projectModel.getName(), "html");
    }
}

