/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.maven.dao;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Iterator;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;

public class MavenProjectService
extends GraphService<MavenProjectModel> {
    public MavenProjectService(GraphContext context) {
        super(context, MavenProjectModel.class);
    }

    public MavenProjectModel createMavenStub(String groupId, String artifactId, String version) {
        MavenProjectModel facet = (MavenProjectModel)this.create();
        facet.setMavenIdentifier(this.generateMavenKey(groupId, artifactId, version));
        facet.setGroupId(groupId);
        facet.setArtifactId(artifactId);
        facet.setVersion(version);
        return facet;
    }

    public Iterable<MavenProjectModel> findByGroupArtifactVersion(String groupId, String artifactId, String version) {
        String key = this.generateMavenKey(groupId, artifactId, version);
        Iterable facet = this.findAllByProperty("mavenIdentifier", key);
        return facet;
    }

    protected String generateMavenKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public boolean isMavenConfiguration(XmlFileModel resource) {
        return new GremlinPipeline((Object)resource.asVertex()).in(new String[]{"xmlFacet"}).as("facet").has("w:vertextype", (Object)this.getTypeValueForSearch()).back("facet").iterator().hasNext();
    }

    public MavenProjectModel getMavenConfigurationFromResource(XmlFileModel resource) {
        Iterator v = new GremlinPipeline((Object)resource.asVertex()).in(new String[]{"xmlFacet"}).as("facet").has("w:vertextype", (Object)this.getTypeValueForSearch()).back("facet").iterator();
        if (v.hasNext()) {
            return (MavenProjectModel)this.getGraphContext().getFramed().frame((Vertex)v.next(), this.getType());
        }
        return null;
    }
}

