/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.reporting.freemarker.FreeMarkerIterationOperation;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.threading.WindupExecutors;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RenderReportRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(RenderReportRuleProvider.class);
    @Inject
    private Furnace furnace;

    public RenderReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(RenderReportRuleProvider.class).setPhase(ReportRenderingPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ReportModel.class).withProperty("templateType", (Object)TemplateType.FREEMARKER.toString())).perform((Operation)new FreeMarkerThreadedRenderer(this.furnace)).addRule().when((Condition)Query.fromType(ReportResourceFileModel.class)).perform((Operation)new AbstractIterationOperation<ReportResourceFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ReportResourceFileModel payload) {
                ReportService reportService = new ReportService(event.getGraphContext());
                Path outputDir = Paths.get(reportService.getReportDirectory(), new String[0]);
                File directory = outputDir.toFile();
                File fullPath = new File(directory, FilenameUtils.separatorsToSystem((String)("resources/" + payload.getPrettyPath())));
                try {
                    FileUtils.forceMkdir((File)fullPath.getParentFile());
                    FileUtils.copyFile((File)payload.asFile(), (File)fullPath);
                    LOG.info("Copied raw file: " + payload.getFilePath() + " to: " + fullPath.getAbsolutePath());
                }
                catch (IOException e) {
                    LOG.warning("Exception creating file: " + fullPath.getAbsolutePath());
                }
            }
        });
    }

    private class FreeMarkerThreadedRenderer
    extends GraphOperation {
        private final Furnace furnace;

        public FreeMarkerThreadedRenderer(Furnace furnace) {
            this.furnace = furnace;
        }

        public void perform(final GraphRewrite event, final EvaluationContext context) {
            Iterable reportModelsIterable = Variables.instance((GraphRewrite)event).findVariable("default");
            final ConcurrentLinkedDeque<WindupVertexFrame> reportModels = new ConcurrentLinkedDeque<WindupVertexFrame>();
            for (WindupVertexFrame frame : reportModelsIterable) {
                reportModels.add(frame);
            }
            final FreeMarkerIterationOperation freeMarkerIterationOperation = FreeMarkerIterationOperation.create((Furnace)this.furnace, (String[])new String[0]);
            final IterationProgress iterationProgress = IterationProgress.monitoring((String)"Rendering Reports", (int)100);
            int threadCount = WindupExecutors.getDefaultThreadCount();
            ExecutorService executorService = WindupExecutors.newFixedThreadPool((int)WindupExecutors.getDefaultThreadCount());
            event.getRewriteContext().put((Object)"default", reportModels);
            iterationProgress.perform(event, context);
            for (int i = 0; i < threadCount; ++i) {
                executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        WindupVertexFrame reportModelObject;
                        while ((reportModelObject = (WindupVertexFrame)reportModels.remove()) != null) {
                            ReportModel reportModel = (ReportModel)reportModelObject;
                            try {
                                Thread.currentThread().setName(reportModel.getTemplatePath() + "_" + reportModel.getReportFilename());
                                iterationProgress.perform(event, context);
                                freeMarkerIterationOperation.perform(event, context, reportModel);
                                continue;
                            }
                            catch (Throwable t) {
                                LOG.log(Level.WARNING, "Failed to render freemarker report: " + reportModel + " due to: " + t.getMessage(), t);
                                continue;
                            }
                            break;
                        }
                        return null;
                    }
                });
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(2L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new WindupException("Failed to render reports due to a timeout: " + e.getMessage(), (Throwable)e);
            }
            event.getRewriteContext().put((Object)"default", null);
        }
    }
}

