/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.ReportFileModel;

public class TagUtil {
    public static boolean checkMatchingTags(Collection<String> tags, Set<String> includeTags, Set<String> excludeTags) {
        return TagUtil.checkMatchingTags(tags, includeTags, excludeTags, true);
    }

    public static boolean checkMatchingTags(Collection<String> tags, Set<String> includeTags, Set<String> excludeTags, boolean strictExclude) {
        boolean foundIncludeMatch = false;
        if (includeTags.isEmpty()) {
            return true;
        }
        for (String tag : tags) {
            if (excludeTags.contains(tag)) {
                if (!strictExclude) continue;
                return false;
            }
            if (!includeTags.isEmpty() && !includeTags.contains(tag)) continue;
            foundIncludeMatch = true;
        }
        return foundIncludeMatch;
    }

    public static boolean hasHintsOrClassificationsWithRelevantTags(ReportFileModel reportFileModel, Set<String> includeTags, Set<String> excludeTags) {
        Set<String> allTags = TagUtil.gatherReportFileTags(reportFileModel);
        return TagUtil.checkMatchingTags(allTags, includeTags, excludeTags, false);
    }

    public static Set<String> gatherReportFileTags(ReportFileModel reportFileModel) {
        HashSet<String> allTags = new HashSet<String>();
        for (ClassificationModel classificationModel : reportFileModel.getClassificationModels()) {
            for (String tag : classificationModel.getTags()) {
                allTags.add(tag);
            }
        }
        for (InlineHintModel inlineHintModel : reportFileModel.getInlineHints()) {
            for (String tag : inlineHintModel.getTags()) {
                allTags.add(tag);
            }
        }
        return allTags;
    }
}

