/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Map;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.service.EffortReportService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetEffortDescriptionForPoints
implements WindupFreeMarkerMethod {
    private static final String NAME = "getEffortDescriptionForPoints";

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Given a number of points, return a short textual description (eg, Trivial or Complex).";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Integer)");
        }
        SimpleNumber simpleNumber = (SimpleNumber)arguments.get(0);
        int effort = simpleNumber.getAsNumber().intValue();
        Map<Integer, String> effortToDescription = EffortReportService.getEffortLevelDescriptionMappings();
        String result = effortToDescription.containsKey(effort) ? effortToDescription.get(effort) : "Unknown";
        ExecutionStatistics.get().end(NAME);
        return result;
    }

    @Override
    public void setContext(GraphRewrite event) {
    }
}

