/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.projects.ui.dependencies.HasManagedDependenciesCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

@FacetConstraint(value={DependencyFacet.class})
public class HasManagedDependenciesCommandImpl
extends AbstractProjectCommand
implements HasManagedDependenciesCommand {
    private UIInputMany<Dependency> arguments;
    private UIInput<Boolean> effective;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.arguments = (UIInputMany)((UIInputMany)((UIInputMany)factory.createInputMany("arguments", 'd', Dependency.class).setLabel("Coordinates")).setRequired(true)).setDescription("The coordinates of the arguments to be checked [groupId :artifactId {:version :scope :packaging}]");
        this.effective = (UIInput)factory.createInput("effective", 'e', Boolean.class).setLabel("Effective");
        builder.add(this.arguments).add(this.effective);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(HasManagedDependenciesCommandImpl.class).description("Check one or more managed dependencies in the current project.").name("Project: Has Managed Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            int numberOfGavsFound = 0;
            int numberOfGavs = 0;
            for (Dependency gav : this.arguments.getValue()) {
                ++numberOfGavs;
                DependencyBuilder dep = DependencyBuilder.create((Dependency)gav);
                if (((Boolean)this.effective.getValue()).booleanValue()) {
                    if (!deps.hasEffectiveManagedDependency(gav)) continue;
                    ++numberOfGavsFound;
                    continue;
                }
                if (!deps.hasDirectManagedDependency((Dependency)dep)) continue;
                ++numberOfGavsFound;
            }
            if (numberOfGavs == numberOfGavsFound) {
                return Results.success((String)"All arguments found");
            }
            return Results.fail((String)("Missing " + (numberOfGavs - numberOfGavsFound)));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

