/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.repositories;

import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.projects.ui.repositories.RemoveRepositoryCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

@FacetConstraint(value={DependencyFacet.class})
public class RemoveRepositoryCommandImpl
extends AbstractProjectCommand
implements RemoveRepositoryCommand {
    private UIInput<String> url;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.url = (UIInput)((UIInput)((UIInput)factory.createInput("url", String.class).setLabel("Repository URL")).setRequired(true)).setDescription("The repository URL");
        builder.add(this.url);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(RemoveRepositoryCommandImpl.class).description("Remove a repository configured in the current project descriptor.").name("Project: Remove Repository").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public Result execute(UIExecutionContext context) {
        String urlValue;
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        DependencyRepository rep = deps.removeRepository(urlValue = (String)this.url.getValue());
        Result result = rep != null ? Results.success((String)("Removed repository [" + rep.getId() + "->" + rep.getUrl() + "]")) : Results.fail((String)("No repository with url [" + urlValue + "]"));
        return result;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

