/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Error;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public final class DynamicMethod
extends MethodInfo {
    private static final Method INVOKE_EXACT;
    private static final Method INVOKE;
    private final ParameterList _parameters;
    private final Method _invokeMethod;
    private final MethodHandle _methodHandle;
    private final SignatureType _signatureType;

    public static DynamicMethod invoke(MethodHandle methodHandle) {
        return new DynamicMethod(methodHandle, INVOKE);
    }

    public static DynamicMethod invokeExact(MethodHandle methodHandle) {
        return new DynamicMethod(methodHandle, INVOKE_EXACT);
    }

    public static DynamicMethod invoke(MethodType methodType) {
        return new DynamicMethod(methodType, INVOKE);
    }

    public static DynamicMethod invokeExact(MethodType methodType) {
        return new DynamicMethod(methodType, INVOKE_EXACT);
    }

    private DynamicMethod(MethodHandle methodHandle, Method invokeMethod) {
        this._methodHandle = (MethodHandle)VerifyArgument.notNull((Object)methodHandle, (String)"methodHandle");
        this._invokeMethod = (Method)VerifyArgument.notNull((Object)invokeMethod, (String)"invokeMethod");
        MethodType methodType = methodHandle.type();
        ParameterInfo[] parameters = new ParameterInfo[methodType.parameterCount()];
        int n = parameters.length;
        for (int i = 0; i < n; ++i) {
            parameters[i] = new ParameterInfo("p" + i, i, Type.of(methodType.parameterType(i)));
        }
        this._parameters = new ParameterList(parameters);
        this._signatureType = new SignatureType(Type.of(methodType.returnType()), this._parameters.getParameterTypes());
    }

    private DynamicMethod(MethodType methodType, Method invokeMethod) {
        VerifyArgument.notNull((Object)methodType, (String)"methodType");
        this._invokeMethod = (Method)VerifyArgument.notNull((Object)invokeMethod, (String)"invokeMethod");
        this._methodHandle = null;
        ParameterInfo[] parameters = new ParameterInfo[methodType.parameterCount()];
        int n = parameters.length;
        for (int i = 0; i < n; ++i) {
            parameters[i] = new ParameterInfo("p" + i, i, Type.of(methodType.parameterType(i)));
        }
        this._parameters = new ParameterList(parameters);
        this._signatureType = new SignatureType(Type.of(methodType.returnType()), this._parameters.getParameterTypes());
    }

    public MethodHandle getHandle() {
        return this._methodHandle;
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        return this._invokeMethod;
    }

    @Override
    public Type getDeclaringType() {
        return Types.MethodHandle;
    }

    @Override
    public int getModifiers() {
        return this._invokeMethod.getModifiers();
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    static {
        try {
            INVOKE = MethodHandle.class.getMethod("invoke", Object[].class);
            INVOKE_EXACT = MethodHandle.class.getMethod("invokeExact", Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw Error.targetInvocationException(e);
        }
    }
}

