/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.util.structures.Pair;
import java.util.Comparator;
import java.util.TreeSet;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.model.DefaultTechnologyTagComparator;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;

public class TechnologyTagService
extends GraphService<TechnologyTagModel> {
    public TechnologyTagService(GraphContext context) {
        super(context, TechnologyTagModel.class);
    }

    public TechnologyTagModel addTagToFileModel(FileModel fileModel, String tagName, TechnologyTagLevel level) {
        FramedGraphQuery q = this.getGraphContext().getQuery().type(TechnologyTagModel.class).has("name", (Object)tagName);
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((GraphQuery)q);
        if (technologyTag == null) {
            technologyTag = (TechnologyTagModel)this.create();
            technologyTag.setName(tagName);
            technologyTag.setLevel(level);
        }
        if (level == TechnologyTagLevel.IMPORTANT && fileModel instanceof SourceFileModel) {
            ((SourceFileModel)fileModel).setGenerateSourceReport(true);
        }
        technologyTag.addFileModel(fileModel);
        return technologyTag;
    }

    public void removeTagFromFileModel(FileModel fileModel, String tagName) {
        FramedGraphQuery q = this.getGraphContext().getQuery().type(TechnologyTagModel.class).has("name", (Object)tagName);
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((GraphQuery)q);
        if (technologyTag != null) {
            technologyTag.removeFileModel(fileModel);
        }
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForFile(FileModel fileModel) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)fileModel.asVertex());
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"TechnologyTag");
        pipeline.order((PipeFunction)new PipeFunction<Pair<Vertex, Vertex>, Integer>(){
            private Comparator<TechnologyTagModel> comparator = new DefaultTechnologyTagComparator();

            public Integer compute(Pair<Vertex, Vertex> argument) {
                return this.comparator.compare((TechnologyTagModel)TechnologyTagService.this.frame((Vertex)argument.getA()), (TechnologyTagModel)TechnologyTagService.this.frame((Vertex)argument.getB()));
            }
        });
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, TechnologyTagModel.class);
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForProject(ProjectModelTraversal traversal) {
        TreeSet<TechnologyTagModel> results = new TreeSet<TechnologyTagModel>(new DefaultTechnologyTagComparator());
        GremlinPipeline pipeline = new GremlinPipeline((Object)traversal.getCanonicalProject().asVertex());
        pipeline.out(new String[]{"projectModelToFile"});
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"TechnologyTag");
        FramedVertexIterable modelIterable = new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, TechnologyTagModel.class);
        results.addAll(Iterators.asSet((Iterable)modelIterable));
        for (ProjectModelTraversal childTraversal : traversal.getChildren()) {
            results.addAll(Iterators.asSet(this.findTechnologyTagsForProject(childTraversal)));
        }
        return results;
    }
}

