/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss.jbpm3;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.Jbpm3ProcessModel;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverXmlFilesRuleProvider.class}, perform="Discover JBoss EJB XML Files")
public class DiscoverJBossJbpmProcessFilesRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverJBossJbpmProcessFilesRuleProvider.class.getSimpleName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"process-definition");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        if (JOOX.$((Document)payload.asDocument()).find("start-state").isEmpty()) {
            LOG.warning("Found process-definition, but no start-state.");
            return;
        }
        Jbpm3ProcessModel processModel = (Jbpm3ProcessModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, Jbpm3ProcessModel.class);
        Document doc = payload.asDocument();
        String processName = JOOX.$((Document)doc).attr("name");
        if (StringUtils.isNotBlank((CharSequence)processName)) {
            processModel.setProcessName(processName);
            LOG.info("Found process: " + processName);
        } else {
            LOG.info("Process name is null for process: " + payload.getFilePath());
        }
        processModel.setNodeCount(JOOX.$((Document)doc).find("node").get().size());
        processModel.setDecisionCount(JOOX.$((Document)doc).find("decision").get().size());
        processModel.setStateCount(JOOX.$((Document)doc).find("state").get().size());
        processModel.setTaskCount(JOOX.$((Document)doc).find("task").get().size());
        processModel.setSubProcessCount(JOOX.$((Document)doc).find("sub-process").get().size());
        for (Element action : JOOX.$((Document)doc).find("action").get()) {
            String actionName = JOOX.$((Element)action).attr("name");
            String className = JOOX.$((Element)action).attr("class");
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            JavaClassModel javaClass = javaClassService.getOrCreatePhantom(className);
            processModel.addActionHandler(javaClass);
        }
        for (Element decision : JOOX.$((Document)doc).find("decision").get()) {
            for (Element handler : JOOX.$((Element)decision).find("handler").get()) {
                String className = JOOX.$((Element)handler).attr("class");
                if (!StringUtils.isNotBlank((CharSequence)className)) continue;
                JavaClassModel javaClass = javaClassService.getOrCreatePhantom(className);
                processModel.addDecisionHandler(javaClass);
            }
        }
        String processImage = payload.getFilePath();
        processImage = StringUtils.removeEnd((String)processImage, (String)payload.getFileName());
        processImage = processImage + "processimage.jpg";
        FileService fileService = new FileService(event.getGraphContext());
        FileModel processDefinitionImage = fileService.findByPath(processImage);
        if (processDefinitionImage == null) {
            LOG.warning("Expected process definition image at: " + processImage + ", but wasn't found.");
        } else {
            ReportResourceFileModel reportResource = (ReportResourceFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)processDefinitionImage, ReportResourceFileModel.class);
            processModel.setProcessImage(reportResource);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(context, processDefinitionImage, "JBPM Process Image", "JBPM 3 Process Image.");
            TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
            TechnologyTagModel techTag = technologyTagService.addTagToFileModel(processDefinitionImage, "JBoss Process Image", TechnologyTagLevel.IMPORTANT);
            techTag.setVersion("3");
        }
    }
}

