/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractList;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<T>
extends AbstractList<T> {
    private static final ImmutableList<?> EMPTY_LIST = new ImmutableList<Object>(){

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("Empty list has no element with index " + n);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ImmutableList<Object> append(Object object) {
            return 1.of(object);
        }
    };

    public abstract ImmutableList<T> append(T var1);

    public static <T> ImmutableList<T> copyOf(List<T> regularList) {
        Preconditions.checkArgNotNull(regularList, "other");
        return regularList instanceof ImmutableList ? regularList : new RegularList(regularList.toArray());
    }

    public static <T> ImmutableList<T> of() {
        return EMPTY_LIST;
    }

    public static <T> ImmutableList<T> of(T t) {
        return new SingleElementList<T>(t);
    }

    public static <T> ImmutableList<T> of(T t, T t2) {
        return new TwoElementList(t, t2);
    }

    public static <T> ImmutableList<T> of(T t, T t2, T t3) {
        return new RegularList(new Object[]{t, t2, t3});
    }

    public static <T> ImmutableList<T> of(T ... TArray) {
        Preconditions.checkArgNotNull(TArray, "elements");
        return new RegularList((Object[])TArray.clone());
    }

    public static <T> ImmutableList<T> of(T t, T[] TArray) {
        Preconditions.checkArgNotNull(TArray, "more");
        return new RegularList(Utils.arrayOf(t, (Object[])TArray.clone()));
    }

    public static <T> ImmutableList<T> of(T[] TArray, T t) {
        Preconditions.checkArgNotNull(TArray, "first");
        return new RegularList(Utils.arrayOf((Object[])TArray.clone(), t));
    }

    public static <T> ImmutableList<T> of(T t, ImmutableList<T> immutableList) {
        Preconditions.checkArgNotNull(immutableList, "more");
        if (immutableList instanceof SingleElementList) {
            return ImmutableList.of(t, ((SingleElementList)immutableList).element);
        }
        if (immutableList instanceof TwoElementList) {
            TwoElementList twoElementList = (TwoElementList)immutableList;
            return new RegularList(new Object[]{t, twoElementList.element0, twoElementList.element1});
        }
        if (immutableList instanceof RegularList) {
            RegularList regularList = (RegularList)immutableList;
            return new RegularList(Utils.arrayOf(t, regularList.elements));
        }
        Preconditions.checkState(immutableList == EMPTY_LIST);
        return ImmutableList.of(t);
    }

    public static <T> ImmutableList<T> of(ImmutableList<T> immutableList, T t) {
        Preconditions.checkArgNotNull(immutableList, "more");
        if (immutableList instanceof SingleElementList) {
            return ImmutableList.of(((SingleElementList)immutableList).element, t);
        }
        if (immutableList instanceof TwoElementList) {
            TwoElementList twoElementList = (TwoElementList)immutableList;
            return new RegularList(new Object[]{twoElementList.element0, twoElementList.element1, t});
        }
        if (immutableList instanceof RegularList) {
            RegularList regularList = (RegularList)immutableList;
            return new RegularList(Utils.arrayOf(regularList.elements, t));
        }
        Preconditions.checkState(immutableList == EMPTY_LIST);
        return ImmutableList.of(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegularList
    extends ImmutableList<Object> {
        private final Object[] elements;

        private RegularList(Object[] objectArray) {
            this.elements = objectArray;
        }

        @Override
        public Object get(int n) {
            return this.elements[n];
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public ImmutableList<Object> append(Object object) {
            Object[] objectArray = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
            objectArray[this.elements.length] = object;
            return new RegularList(objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TwoElementList<T>
    extends ImmutableList<T> {
        private final T element0;
        private final T element1;

        private TwoElementList(T t, T t2) {
            this.element0 = t;
            this.element1 = t2;
        }

        @Override
        public T get(int n) {
            Preconditions.checkElementIndex(n, 2);
            return n == 0 ? this.element0 : this.element1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public ImmutableList<T> append(T t) {
            return TwoElementList.of(this.element0, this.element1, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleElementList<T>
    extends ImmutableList<T> {
        private final T element;

        public SingleElementList(T t) {
            this.element = t;
        }

        @Override
        public T get(int n) {
            Preconditions.checkElementIndex(n, 1);
            return this.element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ImmutableList<T> append(T t) {
            return SingleElementList.of(this.element, t);
        }
    }
}

