/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.profiles.Profile;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDependantsReport
extends CLSReport {
    private static final String NAME = "Class Dependants";
    private static final String DIRECTORY = "classdependants";

    public ClassDependantsReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Class</th>" + Dump.newLine());
        bw.write("     <th>Dependants</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        boolean odd = true;
        for (Archive archive : this.archives) {
            SortedMap<String, SortedSet<String>> classDependencies = this.getClassDependencies(archive);
            for (Map.Entry<String, SortedSet<String>> entry : classDependencies.entrySet()) {
                String clz = entry.getKey();
                SortedSet<String> clzDeps = entry.getValue();
                for (String dep : clzDeps) {
                    if (dep.equals(clz)) continue;
                    boolean include = true;
                    Iterator<Profile> kit = this.getKnown().iterator();
                    while (include && kit.hasNext()) {
                        Profile profile = kit.next();
                        if (!profile.doesProvide(dep)) continue;
                        include = false;
                    }
                    if (!include) continue;
                    TreeSet<String> deps = (TreeSet<String>)result.get(dep);
                    if (deps == null) {
                        deps = new TreeSet<String>();
                    }
                    deps.add(clz);
                    result.put(dep, deps);
                }
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String clz = (String)entry.getKey();
            SortedSet deps = (SortedSet)entry.getValue();
            if (deps == null || deps.size() <= 0) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td>" + clz + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            Iterator sit = deps.iterator();
            while (sit.hasNext()) {
                String dep = (String)sit.next();
                bw.write(dep);
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private SortedMap<String, SortedSet<String>> getClassDependencies(Archive archive) {
        TreeMap<String, SortedSet<String>> classDeps = new TreeMap<String, SortedSet<String>>();
        if (archive instanceof NestableArchive) {
            NestableArchive nestableArchive = (NestableArchive)archive;
            List<Archive> subArchives = nestableArchive.getSubArchives();
            for (Archive sa : subArchives) {
                classDeps.putAll(this.getClassDependencies(sa));
            }
            classDeps.putAll(nestableArchive.getClassDependencies());
        } else {
            classDeps.putAll(archive.getClassDependencies());
        }
        return classDeps;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Class Dependants</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }
}

