/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.reporting.freemarker.FurnaceFreeMarkerTemplateLoader;
import org.jboss.windup.rules.apps.mavenize.MavenizationService;
import org.jboss.windup.rules.apps.mavenize.Pom;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class MavenStructureRenderer {
    private static final Logger LOG = Logging.get(MavenStructureRenderer.class);
    private static final String TEMPLATE_POM_XML = "/org/jboss/windup/rules/apps/mavenize/pom.xml.ftl";
    private static final String TEMPLATE_BOM_XML = "/org/jboss/windup/rules/apps/mavenize/bom.xml.ftl";
    private MavenizationService.MavenizationContext mavCtx;

    MavenStructureRenderer(MavenizationService.MavenizationContext mavCtx) {
        this.mavCtx = mavCtx;
    }

    void createMavenProjectDirectoryTree() {
        try {
            Path mavenizedAppPath = this.mavCtx.getMavenizedBaseDir().resolve(this.mavCtx.getUnifiedAppName());
            MavenStructureRenderer.renderPomXml(this.mavCtx, this.mavCtx.getRootPom(), mavenizedAppPath.resolve("pom.xml"));
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Map.Entry entry : this.mavCtx.getRootPom().submodules.entrySet()) {
                try {
                    String subDir = (String)entry.getKey();
                    Path resultPomXmlPath = mavenizedAppPath.resolve(subDir).resolve("pom.xml");
                    LOG.info("Writing " + subDir + "/pom.xml\n > " + entry.getValue());
                    MavenStructureRenderer.renderPomXml(this.mavCtx, (Pom)entry.getValue(), resultPomXmlPath);
                }
                catch (Throwable ex) {
                    exceptions.add(ex);
                }
            }
            this.throwIfErrors(exceptions);
        }
        catch (Exception ex) {
            throw new WindupException("Failed creating the Maven project structure: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static void renderPomXml(MavenizationService.MavenizationContext mavCtx, Pom pom, Path pomXmlPath) {
        HashMap<String, Pom> vars = new HashMap<String, Pom>();
        vars.put("pom", pom);
        vars.put("config", (Pom)mavCtx.getGraphContext().getUnique(WindupConfigurationModel.class));
        Path template = MavenStructureRenderer.chooseTemplate(pom);
        try {
            LOG.info("Rendering template: " + template + " into " + pomXmlPath + "\n - " + pom);
            Files.createDirectories(pomXmlPath.getParent(), new FileAttribute[0]);
            MavenStructureRenderer.renderFreemarkerTemplate(template, vars, pomXmlPath);
        }
        catch (ParseException ex) {
            throw new WindupException("Could not parse pom.xml template: " + template + "\nReason: " + ex.getMessage(), (Throwable)ex);
        }
        catch (TemplateException | IOException ex) {
            throw new WindupException("Error rendering pom.xml template: " + template + "\nReason: " + ex.getMessage(), ex);
        }
    }

    private static Path chooseTemplate(Pom pom) {
        Path template;
        block0 : switch (pom.role) {
            case BOM: {
                template = Paths.get(TEMPLATE_BOM_XML, new String[0]);
                break;
            }
            default: {
                switch (pom.coord.getPackaging()) {
                    default: {
                        template = Paths.get(TEMPLATE_POM_XML, new String[0]);
                        break block0;
                    }
                    case "bom": 
                }
                template = Paths.get(TEMPLATE_BOM_XML, new String[0]);
            }
        }
        return template;
    }

    private static void renderFreemarkerTemplate(Path templatePath, Map vars, Path outputPath) throws IOException, TemplateException {
        if (templatePath == null) {
            throw new WindupException("templatePath is null");
        }
        Configuration freemarkerConfig = new Configuration(Configuration.VERSION_2_3_23);
        DefaultObjectWrapperBuilder objectWrapperBuilder = new DefaultObjectWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        objectWrapperBuilder.setUseAdaptersForContainers(true);
        freemarkerConfig.setObjectWrapper((ObjectWrapper)objectWrapperBuilder.build());
        freemarkerConfig.setTemplateLoader((TemplateLoader)new FurnaceFreeMarkerTemplateLoader());
        Template template = freemarkerConfig.getTemplate(templatePath.toString());
        try (FileWriter fw = new FileWriter(outputPath.toFile());){
            template.process((Object)vars, (Writer)fw);
        }
    }

    private void throwIfErrors(List<Throwable> exceptions) throws WindupException {
        if (exceptions.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Errors when creating the Maven project directory tree:\n");
        for (Throwable ex : exceptions) {
            sb.append("    ").append(ex.getMessage()).append("\n");
        }
        sb.append("The first error's stack trace:\n    ");
        sb.append(ExceptionUtils.getStackTrace((Throwable)exceptions.get(0)));
        throw new WindupException(sb.toString());
    }
}

