/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.logging.Logger;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.rules.apps.mavenize.ApiDependenciesData;
import org.jboss.windup.rules.apps.mavenize.Dependency;
import org.jboss.windup.rules.apps.mavenize.DependencyDeducer;
import org.jboss.windup.rules.apps.mavenize.MavenCoord;
import org.jboss.windup.rules.apps.mavenize.MavenizationService;
import org.jboss.windup.rules.apps.mavenize.PackagesToContainingMavenArtifactsIndex;
import org.jboss.windup.rules.apps.mavenize.Pom;
import org.jboss.windup.rules.apps.mavenize.SimpleDependency;
import org.jboss.windup.util.Logging;

class FeatureBasedApiDependenciesDeducer
implements DependencyDeducer {
    private static final Logger LOG = Logging.get(FeatureBasedApiDependenciesDeducer.class);
    private MavenizationService.MavenizationContext mavCtx;

    FeatureBasedApiDependenciesDeducer(MavenizationService.MavenizationContext mavCtx) {
        this.mavCtx = mavCtx;
    }

    @Override
    public void addAppropriateDependencies(ProjectModel projectModel, Pom modulePom) {
        this.addDeploymentTypeBasedDependencies(projectModel, modulePom);
        this.addHardcodedRecognitionDependencies(projectModel, modulePom);
        this.addIndexBasedDependencies(projectModel, modulePom);
    }

    private void addIndexBasedDependencies(ProjectModel projectModel, Pom modulePom) {
        PackagesToContainingMavenArtifactsIndex packageIndex = new PackagesToContainingMavenArtifactsIndex(this.mavCtx.getGraphContext());
        for (MavenCoord apiCoords : ApiDependenciesData.API_ARTIFACTS) {
            if (!packageIndex.moduleContainsPackagesFromAPI(projectModel, apiCoords)) continue;
            modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, apiCoords));
        }
    }

    private boolean addDeploymentTypeBasedDependencies(ProjectModel projectModel, Pom modulePom) {
        if (projectModel.getProjectType() == null) {
            return true;
        }
        switch (projectModel.getProjectType()) {
            case "ear": {
                break;
            }
            case "war": {
                modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_SERVLET_31));
                break;
            }
            case "ejb": {
                modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_EJB_32));
                modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_CDI));
                modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_JAVAX_ANN));
                break;
            }
            case "ejb-client": {
                modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_EJB_CLIENT));
            }
        }
        return false;
    }

    private void addHardcodedRecognitionDependencies(ProjectModel projectModel, Pom modulePom) {
        if (this.hasJpaEntities(projectModel)) {
            modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_JPA_21));
        }
        if (this.hasJsf(projectModel)) {
            modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_JSF));
        }
        if (this.hasJaxrs(projectModel)) {
            modulePom.getDependencies().add(new SimpleDependency(Dependency.Role.API, ApiDependenciesData.DEP_API_JAXRS_20));
        }
    }

    private boolean hasJpaEntities(ProjectModel projectModel) {
        return false;
    }

    private boolean hasJsf(ProjectModel projectModel) {
        return false;
    }

    private boolean hasJaxrs(ProjectModel projectModel) {
        return false;
    }

    private boolean moduleContainsClassesFromAPI(ProjectModel projectModel, MavenCoord apiCoords) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

